/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.server.processor.EndpointInvokerFactory;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;

public class ReflectionEndpointInvokerFactory
implements EndpointInvokerFactory {
    @Override
    public Supplier<EndpointInvoker> create(ResourceMethod method, ClassInfo currentClass, final MethodInfo currentMethod) {
        return new Supplier<EndpointInvoker>(){

            @Override
            public EndpointInvoker get() {
                try {
                    Class<?> clazz = Class.forName(currentMethod.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
                    final Method meth = clazz.getDeclaredMethod(currentMethod.name(), this.toParamArray(currentMethod.parameters()));
                    return new EndpointInvoker(){

                        public Object invoke(Object instance, Object[] parameters) throws Exception {
                            return meth.invoke(instance, parameters);
                        }
                    };
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private Class<?>[] toParamArray(List<Type> parameters) {
                Class[] ret = new Class[parameters.size()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = this.toParam(parameters.get(i));
                }
                return ret;
            }

            private Class<?> toParam(Type type) {
                if (type.kind() == Type.Kind.PRIMITIVE) {
                    PrimitiveType prim = type.asPrimitiveType();
                    switch (prim.primitive()) {
                        case INT: {
                            return Integer.TYPE;
                        }
                        case BYTE: {
                            return Byte.TYPE;
                        }
                        case CHAR: {
                            return Character.TYPE;
                        }
                        case LONG: {
                            return Long.TYPE;
                        }
                        case FLOAT: {
                            return Float.TYPE;
                        }
                        case SHORT: {
                            return Short.TYPE;
                        }
                        case DOUBLE: {
                            return Double.TYPE;
                        }
                        case BOOLEAN: {
                            return Boolean.TYPE;
                        }
                    }
                    throw new RuntimeException("Unknown type " + prim.primitive());
                }
                try {
                    return Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

