/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.vertx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class VertxBufferImpl
implements Buffer {
    private ByteBuf buffer;

    public VertxBufferImpl(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public String toString() {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }

    public String toString(String enc) {
        return this.buffer.toString(Charset.forName(enc));
    }

    public String toString(Charset enc) {
        return this.buffer.toString(enc);
    }

    public JsonObject toJsonObject() {
        return new JsonObject((Buffer)this);
    }

    public JsonArray toJsonArray() {
        return new JsonArray((Buffer)this);
    }

    public byte getByte(int pos) {
        return this.buffer.getByte(pos);
    }

    public short getUnsignedByte(int pos) {
        return this.buffer.getUnsignedByte(pos);
    }

    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    public int getIntLE(int pos) {
        return this.buffer.getIntLE(pos);
    }

    public long getUnsignedInt(int pos) {
        return this.buffer.getUnsignedInt(pos);
    }

    public long getUnsignedIntLE(int pos) {
        return this.buffer.getUnsignedIntLE(pos);
    }

    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    public long getLongLE(int pos) {
        return this.buffer.getLongLE(pos);
    }

    public double getDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    public float getFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    public short getShortLE(int pos) {
        return this.buffer.getShortLE(pos);
    }

    public int getUnsignedShort(int pos) {
        return this.buffer.getUnsignedShort(pos);
    }

    public int getUnsignedShortLE(int pos) {
        return this.buffer.getUnsignedShortLE(pos);
    }

    public int getMedium(int pos) {
        return this.buffer.getMedium(pos);
    }

    public int getMediumLE(int pos) {
        return this.buffer.getMediumLE(pos);
    }

    public int getUnsignedMedium(int pos) {
        return this.buffer.getUnsignedMedium(pos);
    }

    public int getUnsignedMediumLE(int pos) {
        return this.buffer.getUnsignedMediumLE(pos);
    }

    public byte[] getBytes() {
        byte[] arr = new byte[this.buffer.writerIndex()];
        this.buffer.getBytes(0, arr);
        return arr;
    }

    public byte[] getBytes(int start, int end) {
        Arguments.require((end >= start ? 1 : 0) != 0, (String)"end must be greater or equal than start");
        byte[] arr = new byte[end - start];
        this.buffer.getBytes(start, arr, 0, end - start);
        return arr;
    }

    public Buffer getBytes(byte[] dst) {
        return this.getBytes(dst, 0);
    }

    public Buffer getBytes(byte[] dst, int dstIndex) {
        return this.getBytes(0, this.buffer.writerIndex(), dst, dstIndex);
    }

    public Buffer getBytes(int start, int end, byte[] dst) {
        return this.getBytes(start, end, dst, 0);
    }

    public Buffer getBytes(int start, int end, byte[] dst, int dstIndex) {
        Arguments.require((end >= start ? 1 : 0) != 0, (String)"end must be greater or equal than start");
        this.buffer.getBytes(start, dst, dstIndex, end - start);
        return this;
    }

    public Buffer getBuffer(int start, int end) {
        return new VertxBufferImpl(Unpooled.wrappedBuffer((byte[])this.getBytes(start, end)));
    }

    public String getString(int start, int end, String enc) {
        byte[] bytes = this.getBytes(start, end);
        Charset cs = Charset.forName(enc);
        return new String(bytes, cs);
    }

    public String getString(int start, int end) {
        byte[] bytes = this.getBytes(start, end);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Buffer appendBuffer(Buffer buff) {
        this.buffer.writeBytes(buff.getByteBuf());
        return this;
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        ByteBuf byteBuf = buff.getByteBuf();
        int from = byteBuf.readerIndex() + offset;
        this.buffer.writeBytes(byteBuf, from, len);
        return this;
    }

    public Buffer appendBytes(byte[] bytes) {
        this.buffer.writeBytes(bytes);
        return this;
    }

    public Buffer appendBytes(byte[] bytes, int offset, int len) {
        this.buffer.writeBytes(bytes, offset, len);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    public Buffer appendUnsignedByte(short b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.buffer.writeInt(i);
        return this;
    }

    public Buffer appendIntLE(int i) {
        this.buffer.writeIntLE(i);
        return this;
    }

    public Buffer appendUnsignedInt(long i) {
        this.buffer.writeInt((int)i);
        return this;
    }

    public Buffer appendUnsignedIntLE(long i) {
        this.buffer.writeIntLE((int)i);
        return this;
    }

    public Buffer appendMedium(int i) {
        this.buffer.writeMedium(i);
        return this;
    }

    public Buffer appendMediumLE(int i) {
        this.buffer.writeMediumLE(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.buffer.writeLong(l);
        return this;
    }

    public Buffer appendLongLE(long l) {
        this.buffer.writeLongLE(l);
        return this;
    }

    public Buffer appendShort(short s) {
        this.buffer.writeShort((int)s);
        return this;
    }

    public Buffer appendShortLE(short s) {
        this.buffer.writeShortLE((int)s);
        return this;
    }

    public Buffer appendUnsignedShort(int s) {
        this.buffer.writeShort(s);
        return this;
    }

    public Buffer appendUnsignedShortLE(int s) {
        this.buffer.writeShortLE(s);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.buffer.writeFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.buffer.writeDouble(d);
        return this;
    }

    public Buffer appendString(String str, String enc) {
        return this.append(str, Charset.forName(Objects.requireNonNull(enc)));
    }

    public Buffer appendString(String str) {
        return this.append(str, CharsetUtil.UTF_8);
    }

    public Buffer setByte(int pos, byte b) {
        this.ensureWritable(pos, 1);
        this.buffer.setByte(pos, (int)b);
        return this;
    }

    public Buffer setUnsignedByte(int pos, short b) {
        this.ensureWritable(pos, 1);
        this.buffer.setByte(pos, (int)b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.ensureWritable(pos, 4);
        this.buffer.setInt(pos, i);
        return this;
    }

    public Buffer setIntLE(int pos, int i) {
        this.ensureWritable(pos, 4);
        this.buffer.setIntLE(pos, i);
        return this;
    }

    public Buffer setUnsignedInt(int pos, long i) {
        this.ensureWritable(pos, 4);
        this.buffer.setInt(pos, (int)i);
        return this;
    }

    public Buffer setUnsignedIntLE(int pos, long i) {
        this.ensureWritable(pos, 4);
        this.buffer.setIntLE(pos, (int)i);
        return this;
    }

    public Buffer setMedium(int pos, int i) {
        this.ensureWritable(pos, 3);
        this.buffer.setMedium(pos, i);
        return this;
    }

    public Buffer setMediumLE(int pos, int i) {
        this.ensureWritable(pos, 3);
        this.buffer.setMediumLE(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.ensureWritable(pos, 8);
        this.buffer.setLong(pos, l);
        return this;
    }

    public Buffer setLongLE(int pos, long l) {
        this.ensureWritable(pos, 8);
        this.buffer.setLongLE(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.ensureWritable(pos, 8);
        this.buffer.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.ensureWritable(pos, 4);
        this.buffer.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShort(pos, (int)s);
        return this;
    }

    public Buffer setShortLE(int pos, short s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShortLE(pos, (int)s);
        return this;
    }

    public Buffer setUnsignedShort(int pos, int s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShort(pos, s);
        return this;
    }

    public Buffer setUnsignedShortLE(int pos, int s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShortLE(pos, s);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.ensureWritable(pos, b.length());
        this.buffer.setBytes(pos, b.getByteBuf());
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.ensureWritable(pos, len);
        ByteBuf byteBuf = b.getByteBuf();
        this.buffer.setBytes(pos, byteBuf, byteBuf.readerIndex() + offset, len);
        return this;
    }

    public VertxBufferImpl setBytes(int pos, ByteBuffer b) {
        this.ensureWritable(pos, b.limit());
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b) {
        this.ensureWritable(pos, b.length);
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b, int offset, int len) {
        this.ensureWritable(pos, len);
        this.buffer.setBytes(pos, b, offset, len);
        return this;
    }

    public Buffer setString(int pos, String str) {
        return this.setBytes(pos, str, CharsetUtil.UTF_8);
    }

    public Buffer setString(int pos, String str, String enc) {
        return this.setBytes(pos, str, Charset.forName(enc));
    }

    public int length() {
        return this.buffer.writerIndex();
    }

    public Buffer copy() {
        return new VertxBufferImpl(this.buffer.copy());
    }

    public Buffer slice() {
        return new VertxBufferImpl(this.buffer.slice());
    }

    public Buffer slice(int start, int end) {
        return new VertxBufferImpl(this.buffer.slice(start, end - start));
    }

    public ByteBuf getByteBuf() {
        return this.buffer;
    }

    private Buffer append(String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.buffer.writeBytes(bytes);
        return this;
    }

    private Buffer setBytes(int pos, String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.ensureWritable(pos, bytes.length);
        this.buffer.setBytes(pos, bytes);
        return this;
    }

    private void ensureWritable(int pos, int len) {
        int ni = pos + len;
        int cap = this.buffer.capacity();
        int over = ni - cap;
        if (over > 0) {
            this.buffer.writerIndex(cap);
            this.buffer.ensureWritable(over);
        }
        if (ni > this.buffer.writerIndex()) {
            this.buffer.writerIndex(ni);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertxBufferImpl buffer1 = (VertxBufferImpl)o;
        return this.buffer != null ? this.buffer.equals((Object)buffer1.buffer) : buffer1.buffer == null;
    }

    public int hashCode() {
        return this.buffer != null ? this.buffer.hashCode() : 0;
    }

    public void writeToBuffer(Buffer buff) {
        buff.appendInt(this.length());
        buff.appendBuffer((Buffer)this);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        Buffer b = buffer.getBuffer(pos + 4, pos + 4 + len);
        this.buffer = b.getByteBuf();
        return pos + 4 + len;
    }
}

