/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.Collection;
import java.util.function.BiConsumer;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ParameterHandler
implements ServerRestHandler {
    private final int index;
    private final String defaultValue;
    private final ParameterExtractor extractor;
    private final ParameterConverter converter;
    private final ParameterType parameterType;
    private final boolean isCollection;
    private final boolean isOptional;

    public ParameterHandler(int index, String defaultValue, ParameterExtractor extractor, ParameterConverter converter, ParameterType parameterType, boolean isCollection, boolean isOptional) {
        this.index = index;
        this.defaultValue = defaultValue;
        this.extractor = extractor;
        this.converter = converter;
        this.parameterType = parameterType;
        this.isCollection = isCollection;
        this.isOptional = isOptional;
    }

    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) {
        try {
            Object result = this.extractor.extractParameter(requestContext);
            if (result instanceof ParameterExtractor.ParameterCallback) {
                requestContext.suspend();
                ((ParameterExtractor.ParameterCallback)result).setListener(new BiConsumer<Object, Throwable>(){

                    @Override
                    public void accept(Object o, Throwable throwable) {
                        if (throwable != null) {
                            requestContext.resume(throwable);
                        } else {
                            ParameterHandler.this.handleResult(o, requestContext, true);
                        }
                    }
                });
            } else {
                this.handleResult(result, requestContext, false);
            }
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                throw e;
            }
            throw new WebApplicationException((Throwable)e, 400);
        }
    }

    private void handleResult(Object result, ResteasyReactiveRequestContext requestContext, boolean needsResume) {
        if (this.defaultValue != null && (result == null || this.isCollection && ((Collection)result).isEmpty())) {
            result = this.defaultValue;
        }
        Throwable toThrow = null;
        if (this.converter != null && (result != null || this.isOptional)) {
            switch (this.parameterType) {
                case COOKIE: 
                case HEADER: 
                case FORM: {
                    try {
                        result = this.converter.convert(result);
                    }
                    catch (WebApplicationException x) {
                        toThrow = x;
                    }
                    catch (Throwable x) {
                        toThrow = new BadRequestException(x);
                    }
                    break;
                }
                case MATRIX: 
                case PATH: 
                case QUERY: {
                    try {
                        result = this.converter.convert(result);
                    }
                    catch (WebApplicationException x) {
                        toThrow = x;
                    }
                    catch (Throwable x) {
                        toThrow = new NotFoundException(x);
                    }
                    break;
                }
                default: {
                    try {
                        result = this.converter.convert(result);
                        break;
                    }
                    catch (Throwable x) {
                        toThrow = x;
                    }
                }
            }
        }
        if (toThrow == null) {
            requestContext.getParameters()[this.index] = result;
        }
        if (needsResume) {
            if (toThrow == null) {
                requestContext.resume();
            } else {
                requestContext.resume(toThrow);
            }
        } else if (toThrow != null) {
            throw ParameterHandler.sneakyThrow(toThrow);
        }
    }

    public static <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

