/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.container.ResourceInfo;
import org.jboss.resteasy.reactive.server.util.MethodId;

public class ResteasyReactiveResourceInfo
implements ResourceInfo {
    private final String name;
    private final Class<?> declaringClass;
    private final Class[] parameterTypes;
    private final Set<String> classAnnotationNames;
    private final Set<String> methodAnnotationNames;
    private volatile Annotation[] classAnnotations;
    private volatile Method method;
    private volatile Annotation[] annotations;
    private volatile Type returnType;
    private volatile String methodId;

    public ResteasyReactiveResourceInfo(String name, Class<?> declaringClass, Class[] parameterTypes, Set<String> classAnnotationNames, Set<String> methodAnnotationNames) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.parameterTypes = parameterTypes;
        this.classAnnotationNames = classAnnotationNames;
        this.methodAnnotationNames = methodAnnotationNames;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Set<String> getClassAnnotationNames() {
        return this.classAnnotationNames;
    }

    public Set<String> getMethodAnnotationNames() {
        return this.methodAnnotationNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod() {
        if (this.method == null) {
            ResteasyReactiveResourceInfo resteasyReactiveResourceInfo = this;
            synchronized (resteasyReactiveResourceInfo) {
                if (this.method == null) {
                    try {
                        Method declaredMethod = this.declaringClass.getMethod(this.name, this.parameterTypes);
                        this.annotations = declaredMethod.getAnnotations();
                        this.returnType = declaredMethod.getGenericReturnType();
                        this.method = declaredMethod;
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.method;
    }

    public Annotation[] getClassAnnotations() {
        if (this.classAnnotations == null) {
            this.classAnnotations = this.declaringClass.getAnnotations();
        }
        return this.classAnnotations;
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.getMethod();
        }
        return this.annotations;
    }

    public Type getGenericReturnType() {
        if (this.returnType == null) {
            this.getMethod();
        }
        return this.returnType;
    }

    public Method getResourceMethod() {
        return this.getMethod();
    }

    public Class<?> getResourceClass() {
        return this.declaringClass;
    }

    public Annotation[] getParameterAnnotations(int index) {
        return this.getMethod().getParameterAnnotations()[index];
    }

    public String getMethodId() {
        if (this.methodId == null) {
            this.methodId = MethodId.get(this.name, this.declaringClass, this.parameterTypes);
        }
        return this.methodId;
    }
}

