/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import org.jboss.resteasy.reactive.DateFormat;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;

public abstract class TemporalParamConverter<T extends Temporal>
implements ParameterConverter {
    private final DateTimeFormatter formatter;

    public TemporalParamConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    protected abstract T convert(String var1);

    protected abstract T convert(String var1, DateTimeFormatter var2);

    @Override
    public Object convert(Object parameter) {
        String strValue = String.valueOf(parameter);
        if (this.formatter == null) {
            return this.convert(strValue);
        }
        return this.convert(strValue, this.formatter);
    }

    @Override
    public void init(ParamConverterProviders deployment, Class<?> rawType, Type genericType, Annotation[] annotations) {
    }

    public static abstract class TemporalSupplier<T extends TemporalParamConverter<?>>
    implements ParameterConverterSupplier {
        private String pattern;
        private String dateTimeFormatterProviderClassName;

        public TemporalSupplier() {
        }

        public TemporalSupplier(String pattern, String dateTimeFormatterProviderClassName) {
            this.pattern = pattern;
            this.dateTimeFormatterProviderClassName = dateTimeFormatterProviderClassName;
        }

        protected abstract T createConverter(DateTimeFormatter var1);

        @Override
        public ParameterConverter get() {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.dateTimeFormatterProviderClassName != null) {
                try {
                    Class<?> formatterProviderClass = Class.forName(this.dateTimeFormatterProviderClassName, true, Thread.currentThread().getContextClassLoader());
                    DateFormat.DateTimeFormatterProvider dateTimeFormatterProvider = (DateFormat.DateTimeFormatterProvider)formatterProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    dateTimeFormatter = (DateTimeFormatter)dateTimeFormatterProvider.get();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create instance of 'dateTimeFormatterProviderClassName'", e);
                }
            } else if (this.pattern != null) {
                dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern);
            }
            return this.createConverter(dateTimeFormatter);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getDateTimeFormatterProviderClassName() {
            return this.dateTimeFormatterProviderClassName;
        }

        public void setDateTimeFormatterProviderClassName(String dateTimeFormatterProviderClassName) {
            this.dateTimeFormatterProviderClassName = dateTimeFormatterProviderClassName;
        }
    }
}

