/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.multipart;

import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.server.multipart.PartItem;

public final class MultipartFormDataOutput {
    private final Map<String, List<PartItem>> parts = new LinkedHashMap<String, List<PartItem>>();

    @Deprecated(forRemoval=true)
    public Map<String, PartItem> getFormData() {
        LinkedHashMap<String, PartItem> result = new LinkedHashMap<String, PartItem>();
        for (Map.Entry<String, List<PartItem>> entry : this.parts.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            int lastIndex = entry.getValue().size() - 1;
            result.put(entry.getKey(), entry.getValue().get(lastIndex));
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, List<PartItem>> getAllFormData() {
        return Collections.unmodifiableMap(this.parts);
    }

    public PartItem addFormData(String key, Object entity, MediaType mediaType) {
        return this.addFormData(key, entity, null, mediaType);
    }

    public PartItem addFormData(String key, Object entity, String genericType, MediaType mediaType) {
        PartItem part = new PartItem(entity, genericType, mediaType);
        return this.addFormData(key, part);
    }

    public PartItem addFormData(String key, Object entity, MediaType mediaType, String filename) {
        PartItem part = new PartItem(entity, null, mediaType, filename);
        return this.addFormData(key, part);
    }

    private PartItem addFormData(String key, PartItem part) {
        List items = this.parts.computeIfAbsent(key, k -> new ArrayList());
        items.add(part);
        return part;
    }
}

