/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.SseUtil;
import org.jboss.resteasy.reactive.server.jaxrs.SseBroadcasterImpl;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;

public class SseEventSinkImpl
implements SseEventSink {
    public static final byte[] EMPTY_BUFFER = new byte[0];
    private ResteasyReactiveRequestContext context;
    private SseBroadcasterImpl broadcaster;
    private boolean closed;

    public SseEventSinkImpl(ResteasyReactiveRequestContext context) {
        this.context = context;
    }

    public synchronized boolean isClosed() {
        return this.context.serverResponse().closed() || this.closed;
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        if (this.isClosed()) {
            throw new IllegalStateException("Already closed");
        }
        return SseUtil.send(this.context, event, Collections.emptyList());
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        ServerHttpResponse response = this.context.serverResponse();
        if (!response.headWritten()) {
            SseUtil.setHeaders(this.context, response);
        }
        response.end();
        this.context.close();
        if (this.broadcaster != null) {
            this.broadcaster.fireClose(this);
        }
    }

    public void sendInitialResponse(ServerHttpResponse response) {
        if (!response.headWritten()) {
            SseUtil.setHeaders(this.context, response);
            this.context.suspend();
            response.write(EMPTY_BUFFER, new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    if (throwable == null) {
                        SseEventSinkImpl.this.context.resume();
                    } else {
                        SseEventSinkImpl.this.context.resume(throwable);
                    }
                }
            });
        }
    }

    void register(SseBroadcasterImpl broadcaster) {
        if (this.broadcaster != null) {
            throw new IllegalStateException("Already registered on a broadcaster");
        }
        this.broadcaster = broadcaster;
    }
}

