/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import java.time.LocalTime;
import org.h2.util.JSR310Utils;
import org.h2.value.Value;

final class LocalTimeCodec
extends AbstractCodec<LocalTime> {
    LocalTimeCodec() {
        super(LocalTime.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 9;
    }

    @Override
    LocalTime doDecode(Value value, Class<? extends LocalTime> type) {
        return (LocalTime)JSR310Utils.valueToLocalTime((Value)value);
    }

    @Override
    Value doEncode(LocalTime value) {
        return JSR310Utils.localTimeToValue((Object)Assert.requireNonNull(value, "value must not be null"));
    }
}

