/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.util;

import reactor.util.annotation.Nullable;

public final class Assert {
    private Assert() {
    }

    public static <T> T requireNonNull(@Nullable T t, String message) {
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static <T> T requireType(Object value, Class<T> type, String message) {
        Assert.requireNonNull(value, "value must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(message, "message must not be null");
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException(message);
        }
        return (T)value;
    }
}

