/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import org.h2.api.Interval;
import org.h2.api.IntervalQualifier;
import org.h2.value.Value;
import org.h2.value.ValueInterval;

final class IntervalCodec
extends AbstractCodec<Interval> {
    IntervalCodec() {
        super(Interval.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return 22 <= dataType && dataType <= 34;
    }

    @Override
    Interval doDecode(Value value, Class<? extends Interval> type) {
        ValueInterval valueInterval = (ValueInterval)value;
        return new Interval(valueInterval.getQualifier(), valueInterval.isNegative(), valueInterval.getLeading(), valueInterval.getRemaining());
    }

    @Override
    Value doEncode(Interval value) {
        Assert.requireNonNull(value, "value must not be null");
        return ValueInterval.from((IntervalQualifier)value.getQualifier(), (boolean)value.isNegative(), (long)value.getLeading(), (long)value.getRemaining());
    }
}

