/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2DatabaseExceptionFactory;
import io.r2dbc.h2.H2Row;
import io.r2dbc.h2.H2RowMetadata;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class H2Result
implements Result {
    private final H2RowMetadata rowMetadata;
    private final Flux<H2Row> rows;
    private final Mono<Long> rowsUpdated;
    private final Flux<? extends Result.Segment> segments;

    H2Result(H2RowMetadata rowMetadata, Flux<H2Row> rows, Mono<Long> rowsUpdated, Flux<? extends Result.Segment> segments) {
        this.rowMetadata = rowMetadata;
        this.rows = Assert.requireNonNull(rows, "rows must not be null");
        this.rowsUpdated = Assert.requireNonNull(rowsUpdated, "rowsUpdated must not be null");
        this.segments = Assert.requireNonNull(segments, "segments must not be null");
    }

    private H2Result(Mono<Long> rowsUpdated, Flux<Result.Segment> segments) {
        this.rowMetadata = null;
        this.rows = Flux.empty();
        this.rowsUpdated = Assert.requireNonNull(rowsUpdated, "rowsUpdated must not be null");
        this.segments = Assert.requireNonNull(segments, "segments must not be null");
    }

    public Mono<Long> getRowsUpdated() {
        return this.rowsUpdated;
    }

    public H2Result filter(Predicate<Result.Segment> filter) {
        Assert.requireNonNull(filter, "predicate must not be null");
        Flux filteredSegments = this.segments.filter(filter::test);
        return new H2Result(this.rowMetadata, this.rows, this.rowsUpdated, (Flux<? extends Result.Segment>)filteredSegments);
    }

    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.segments.flatMap(segment -> {
            Publisher result = (Publisher)f.apply((Result.Segment)segment);
            if (result == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (result instanceof Mono) {
                return result;
            }
            return Flux.from((Publisher)result);
        });
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.rows.map(row -> f.apply((Row)row, this.rowMetadata));
    }

    public String toString() {
        return "H2Result{, rowMetadata=" + this.rowMetadata + ", rows=" + this.rows + ", rowsUpdated=" + this.rowsUpdated + '}';
    }

    static H2Result toResult(Codecs codecs, @Nullable Long rowsUpdated) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        return new H2Result((Mono<Long>)Mono.justOrEmpty((Object)rowsUpdated), (Flux<Result.Segment>)Flux.just(() -> rowsUpdated));
    }

    static H2Result toResult(Codecs codecs, final ResultInterface result, @Nullable Long rowsUpdated) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(result, "result must not be null");
        H2RowMetadata rowMetadata = H2RowMetadata.toRowMetadata(codecs, result);
        Iterable iterable = () -> new Iterator<Value[]>(){

            @Override
            public boolean hasNext() {
                boolean b = result.hasNext();
                if (!b) {
                    result.close();
                }
                return b;
            }

            @Override
            public Value[] next() {
                result.next();
                return result.currentRow();
            }
        };
        Flux rows = Flux.fromIterable(iterable).map(values -> H2Row.toRow(values, result, codecs, rowMetadata)).onErrorMap(DbException.class, H2DatabaseExceptionFactory::convert);
        return new H2Result(rowMetadata, (Flux<H2Row>)rows, (Mono<Long>)Mono.justOrEmpty((Object)rowsUpdated), (Flux<? extends Result.Segment>)rows);
    }
}

