/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.EscapeAwareColumnMatcher;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

abstract class ColumnSource {
    private final Column[] columns;
    private final Map<String, Column> nameKeyedColumns;

    ColumnSource(Column[] columns, Map<String, Column> nameKeyedColumns) {
        this.columns = columns;
        this.nameKeyedColumns = nameKeyedColumns;
    }

    Column getColumn(Object identifier) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof Integer) {
            return this.getColumn((Integer)identifier);
        }
        if (identifier instanceof String) {
            return this.getColumn((String)identifier);
        }
        throw new IllegalArgumentException(String.format("Identifier [%s] is not a valid identifier. Should either be an Integer index or a String column name.", identifier));
    }

    Column getColumn(int index) {
        if (this.columns.length > index && index >= 0) {
            return this.columns[index];
        }
        throw new IllegalArgumentException(String.format("Column index [%d] is larger than the number of columns [%d]", index, this.columns.length));
    }

    Column getColumn(String name) {
        Column column = this.findColumn(name);
        if (column == null) {
            throw new IllegalArgumentException(String.format("Column name [%s] does not exist in column names %s", name, this.nameKeyedColumns.keySet()));
        }
        return column;
    }

    @Nullable
    Column findColumn(String name) {
        Column column = this.nameKeyedColumns.get(name);
        if (column == null && (name = EscapeAwareColumnMatcher.findColumn(name, this.nameKeyedColumns.keySet())) != null) {
            column = this.nameKeyedColumns.get(name);
        }
        return column;
    }

    int getColumnCount() {
        return this.columns.length;
    }

    Column[] getColumns() {
        return this.columns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [").append(Arrays.stream(this.columns).map(Column::getName).collect(Collectors.joining(", "))).append("]");
        return sb.toString();
    }
}

