/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ErrorDetails;
import io.r2dbc.mssql.MssqlException;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.token.AbstractInfoToken;
import io.r2dbc.mssql.message.token.ErrorToken;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import reactor.core.publisher.SynchronousSink;

final class ExceptionFactory {
    private final String sql;

    private ExceptionFactory(String sql) {
        this.sql = sql;
    }

    static ExceptionFactory withSql(String sql) {
        return new ExceptionFactory(sql);
    }

    R2dbcException createException(AbstractInfoToken token) {
        return ExceptionFactory.createException(token, this.sql);
    }

    static R2dbcException createException(AbstractInfoToken token, String sql) {
        switch ((int)token.getNumber()) {
            case 106: 
            case 130: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 213: 
            case 267: 
            case 565: 
            case 2812: 
            case 4408: {
                return new MssqlBadGrammarException(ExceptionFactory.createExceptionDetails(token), sql);
            }
            case 544: 
            case 2601: 
            case 2627: 
            case 8114: 
            case 8115: {
                return new MssqlDataIntegrityViolationException(ExceptionFactory.createExceptionDetails(token));
            }
            case 701: 
            case 1204: 
            case 1222: {
                return new MssqlTransientException(ExceptionFactory.createExceptionDetails(token));
            }
            case 1203: 
            case 1206: 
            case 1215: 
            case 1216: 
            case 1221: 
            case 3938: 
            case 28611: {
                return new MssqlRollbackException(ExceptionFactory.createExceptionDetails(token));
            }
            case 921: 
            case 941: 
            case 1105: 
            case 1456: 
            case 5061: 
            case 10930: 
            case 40642: 
            case 40675: 
            case 40825: 
            case 45168: {
                return new MssqlTransientResourceException(ExceptionFactory.createExceptionDetails(token));
            }
        }
        if (token.getClassification() == AbstractInfoToken.Classification.GENERAL_ERROR && token.getNumber() == 4002L) {
            return new ProtocolException(token.getMessage());
        }
        switch (token.getClassification()) {
            case OBJECT_DOES_NOT_EXIST: 
            case SYNTAX_ERROR: {
                return new MssqlBadGrammarException(ExceptionFactory.createExceptionDetails(token), sql);
            }
            case INCONSISTENT_NO_LOCK: {
                return new MssqlDataIntegrityViolationException(ExceptionFactory.createExceptionDetails(token));
            }
            case TX_DEADLOCK: {
                return new MssqlRollbackException(ExceptionFactory.createExceptionDetails(token));
            }
            case SECURITY: {
                return new MssqlPermissionDeniedException(ExceptionFactory.createExceptionDetails(token));
            }
            case GENERAL_ERROR: {
                return new MssqlNonTransientException(ExceptionFactory.createExceptionDetails(token));
            }
            case OUT_OF_RESOURCES: {
                return new MssqlTransientResourceException(ExceptionFactory.createExceptionDetails(token));
            }
        }
        return new MssqlNonTransientResourceException(ExceptionFactory.createExceptionDetails(token));
    }

    void handleErrorResponse(Message message, SynchronousSink<Message> sink) {
        if (message instanceof ErrorToken) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorToken)message, this.sql));
        } else {
            sink.next((Object)message);
        }
    }

    RuntimeException createException(ErrorToken message) {
        return ExceptionFactory.createException(message, this.sql);
    }

    private static ErrorDetails createExceptionDetails(AbstractInfoToken token) {
        return new ErrorDetails(token.getMessage(), token.getNumber(), token.getState(), token.getInfoClass(), token.getServerName(), token.getProcName(), token.getLineNumber());
    }

    private static final class MssqlTransientResourceException
    extends R2dbcTransientResourceException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlTransientResourceException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlTransientException
    extends R2dbcTransientException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        public MssqlTransientException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlTimeoutException
    extends R2dbcTimeoutException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlTimeoutException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlRollbackException
    extends R2dbcRollbackException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlRollbackException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlPermissionDeniedException
    extends R2dbcPermissionDeniedException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlPermissionDeniedException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlNonTransientResourceException
    extends R2dbcNonTransientResourceException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlNonTransientResourceException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlNonTransientException
    extends R2dbcNonTransientException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlNonTransientException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlDataIntegrityViolationException
    extends R2dbcDataIntegrityViolationException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlDataIntegrityViolationException(ErrorDetails errorDetails) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber());
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }

    static final class MssqlBadGrammarException
    extends R2dbcBadGrammarException
    implements MssqlException {
        private final ErrorDetails errorDetails;

        MssqlBadGrammarException(ErrorDetails errorDetails, String offendingSql) {
            super(errorDetails.getMessage(), errorDetails.getStateCode(), (int)errorDetails.getNumber(), offendingSql);
            this.errorDetails = errorDetails;
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }
}

