/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.MssqlStatement;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

abstract class MssqlStatementSupport
implements MssqlStatement {
    static final int FETCH_SIZE = 128;
    static final int FETCH_UNCONFIGURED = -1;
    private final boolean preferCursoredExecution;
    @Nullable
    private String[] generatedColumns;
    private int fetchSize = -1;

    MssqlStatementSupport(boolean preferCursoredExecution) {
        this.preferCursoredExecution = preferCursoredExecution;
    }

    int getEffectiveFetchSize() {
        if (this.preferCursoredExecution) {
            return this.fetchSize == -1 ? 128 : this.fetchSize;
        }
        return this.fetchSize == -1 ? 0 : this.fetchSize;
    }

    @Nullable
    String[] getGeneratedColumns() {
        return this.generatedColumns;
    }

    @Override
    public MssqlStatementSupport returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        this.generatedColumns = columns;
        return this;
    }

    @Override
    public MssqlStatementSupport fetchSize(int fetchSize) {
        Assert.isTrue(fetchSize >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = fetchSize;
        return this;
    }
}

