/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.DoubleCodec;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;

final class FloatCodec
extends AbstractCodec<Float> {
    static final FloatCodec INSTANCE = new FloatCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.REAL));

    private FloatCodec() {
        super(Float.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Float value) {
        return RpcEncoding.encodeFixed(allocator, SqlServerType.REAL, value, Encode::asFloat);
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.REAL);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return DoubleCodec.INSTANCE.doCanDecode(typeInformation);
    }

    @Override
    Float doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends Float> valueType) {
        Object value = DoubleCodec.INSTANCE.doDecode(buffer, length, type, Double.class);
        return value == null ? null : Float.valueOf(((Double)value).floatValue());
    }
}

