/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.LocalDateCodec;
import io.r2dbc.mssql.codec.LocalTimeCodec;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

final class LocalDateTimeCodec
extends AbstractCodec<LocalDateTime> {
    public static final LocalDateTimeCodec INSTANCE = new LocalDateTimeCodec();
    private static final LocalDateTime DATETIME_ZERO = LocalDateTime.of(1900, 1, 1, 0, 0, 0, 0);
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeTemporalNull(alloc, SqlServerType.DATETIME2, 7));

    private LocalDateTimeCodec() {
        super(LocalDateTime.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, LocalDateTime value) {
        return RpcEncoding.encode(allocator, SqlServerType.DATETIME2, 8, value, (buffer, localDateTime) -> LocalDateTimeCodec.encode(buffer, SqlServerType.DATETIME2, 7, localDateTime));
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.DATETIME2);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.SMALLDATETIME || typeInformation.getServerType() == SqlServerType.DATETIME || typeInformation.getServerType() == SqlServerType.DATETIME2;
    }

    @Override
    LocalDateTime doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends LocalDateTime> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (type.getServerType() == SqlServerType.SMALLDATETIME) {
            int daysSinceBaseDate = Decode.uShort(buffer);
            int minutesSinceMidnight = Decode.uShort(buffer);
            return DATETIME_ZERO.plusDays(daysSinceBaseDate).plusMinutes(minutesSinceMidnight);
        }
        if (type.getServerType() == SqlServerType.DATETIME) {
            int daysSinceBaseDate = Decode.asInt(buffer);
            long ticksSinceMidnight = (Decode.asInt(buffer) * 10 + 1) / 3;
            int subSecondNanos = (int)(ticksSinceMidnight * NANOS_PER_MILLISECOND % NANOS_PER_SECOND);
            return DATETIME_ZERO.plusDays(daysSinceBaseDate).plus(ticksSinceMidnight, ChronoUnit.MILLIS).withNano(subSecondNanos);
        }
        if (type.getServerType() == SqlServerType.DATETIME2) {
            Object localTime = LocalTimeCodec.INSTANCE.doDecode(buffer, length, type, LocalTime.class);
            Object localDate = LocalDateCodec.INSTANCE.doDecode(buffer, length, type, LocalDate.class);
            return ((LocalTime)localTime).atDate((LocalDate)localDate);
        }
        throw new UnsupportedOperationException(String.format("Cannot decode value from server type [%s]", new Object[]{type.getServerType()}));
    }

    static void encode(ByteBuf buffer, SqlServerType type, int scale, LocalDateTime value) {
        if (type == SqlServerType.SMALLDATETIME) {
            LocalDateTime midnight = value.truncatedTo(ChronoUnit.DAYS);
            int daysSinceBaseDate = Math.toIntExact(Duration.between(DATETIME_ZERO, midnight).toDays());
            int minutesSinceMidnight = (int)Duration.between(midnight, value).toMinutes();
            Encode.uShort(buffer, daysSinceBaseDate);
            Encode.uShort(buffer, minutesSinceMidnight);
            return;
        }
        if (type == SqlServerType.DATETIME) {
            LocalDateTime midnight = value.truncatedTo(ChronoUnit.DAYS);
            int daysSinceBaseDate = Math.toIntExact(Duration.between(DATETIME_ZERO, midnight).toDays());
            Duration time = Duration.between(midnight, value);
            long ticksSinceMidnight = (3L * time.toMillis() + 5L) / 10L;
            Encode.asInt(buffer, daysSinceBaseDate);
            Encode.asInt(buffer, (int)ticksSinceMidnight);
            return;
        }
        if (type == SqlServerType.DATETIME2) {
            LocalTimeCodec.doEncode(buffer, scale, value.toLocalTime());
            LocalDateCodec.encode(buffer, value.toLocalDate());
            return;
        }
        throw new UnsupportedOperationException(String.format("Cannot encode [%s] to server type [%s]", new Object[]{value, type}));
    }
}

