/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.util.UUID;

final class UuidCodec
extends AbstractCodec<UUID> {
    static final UuidCodec INSTANCE = new UuidCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.GUID));

    private UuidCodec() {
        super(UUID.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, UUID value) {
        return RpcEncoding.encode(allocator, SqlServerType.GUID, 16, value, (buffer, uuid) -> {
            long msb = value.getMostSignificantBits();
            long lsb = value.getLeastSignificantBits();
            buffer.writeBytes(this.swapForWrite(msb));
            buffer.writeLong(lsb);
        });
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.GUID);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.GUID;
    }

    @Override
    UUID doDecode(ByteBuf buffer, Length length, TypeInformation typeInformation, Class<? extends UUID> valueType) {
        if (length.isNull()) {
            return null;
        }
        byte[] bytes = new byte[8];
        buffer.readBytes(bytes);
        long msb = UuidCodec.swapForRead(bytes);
        long lsb = buffer.readLong();
        return new UUID(msb, lsb);
    }

    private static long swapForRead(byte[] memory) {
        return ((long)memory[3] & 0xFFL) << 56 | ((long)memory[2] & 0xFFL) << 48 | ((long)memory[1] & 0xFFL) << 40 | ((long)memory[0] & 0xFFL) << 32 | ((long)memory[5] & 0xFFL) << 24 | ((long)memory[4] & 0xFFL) << 16 | ((long)memory[7] & 0xFFL) << 8 | (long)memory[6] & 0xFFL;
    }

    private byte[] swapForWrite(long msb) {
        byte[] bytes = new byte[8];
        bytes[3] = (byte)(msb >> 56 & 0xFFL);
        bytes[2] = (byte)(msb >> 48 & 0xFFL);
        bytes[1] = (byte)(msb >> 40 & 0xFFL);
        bytes[0] = (byte)(msb >> 32 & 0xFFL);
        bytes[5] = (byte)(msb >> 24 & 0xFFL);
        bytes[4] = (byte)(msb >> 16 & 0xFFL);
        bytes[7] = (byte)(msb >> 8 & 0xFFL);
        bytes[6] = (byte)(msb & 0xFFL);
        return bytes;
    }
}

