/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDoneToken;

public final class DoneToken
extends AbstractDoneToken {
    public static final byte TYPE = -3;
    private static final DoneToken[] INTERMEDIATE = new DoneToken[48];
    private static final DoneToken[] MORE_WITH_COUNT_CACHE = new DoneToken[48];
    private static final DoneToken[] DONE_WITH_COUNT_CACHE = new DoneToken[48];
    private static final DoneToken[] MORE_CACHE = new DoneToken[48];
    private static final int DONE_WITH_COUNT = 16;
    private static final int MORE_WITH_COUNT = 17;
    private static final int MORE = 1;

    private DoneToken(int status, int currentCommand, long rowCount) {
        super((byte)-3, status, currentCommand, rowCount);
    }

    public static DoneToken create(long rowCount) {
        return DoneToken.create0(16, 0, rowCount);
    }

    public static DoneToken count(long rowCount) {
        return DoneToken.create0(16, 0, rowCount);
    }

    public static DoneToken more(long rowCount) {
        return DoneToken.create0(17, 0, rowCount);
    }

    public static boolean isDone(Message message) {
        if (message instanceof DoneToken) {
            return ((AbstractDoneToken)message).isDone();
        }
        return false;
    }

    public static DoneToken decode(ByteBuf buffer) {
        int status = Decode.uShort(buffer);
        int currentCommand = Decode.uShort(buffer);
        long rowCount = Decode.uLongLong(buffer);
        return DoneToken.create0(status, currentCommand, rowCount);
    }

    private static DoneToken create0(int status, int currentCommand, long rowCount) {
        if (rowCount >= 0L && rowCount < 48L) {
            switch (status) {
                case 0: {
                    return INTERMEDIATE[(int)rowCount];
                }
                case 16: {
                    return DONE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 17: {
                    return MORE_WITH_COUNT_CACHE[(int)rowCount];
                }
                case 1: {
                    return MORE_CACHE[(int)rowCount];
                }
            }
        }
        return new DoneToken(status, currentCommand, rowCount);
    }

    @Override
    public String getName() {
        return "DONE";
    }

    static {
        for (int i = 0; i < INTERMEDIATE.length; ++i) {
            DoneToken.INTERMEDIATE[i] = new DoneToken(0, 0, i);
            DoneToken.DONE_WITH_COUNT_CACHE[i] = new DoneToken(16, 0, i);
            DoneToken.MORE_WITH_COUNT_CACHE[i] = new DoneToken(17, 0, i);
            DoneToken.MORE_CACHE[i] = new DoneToken(1, 0, i);
        }
    }
}

