/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.util.Assert;
import java.util.Arrays;

public final class NbcRowToken
extends RowToken {
    public static final byte TYPE = -46;
    private final boolean[] nullMarker;

    private NbcRowToken(ByteBuf[] data, boolean[] nullMarker) {
        super(data);
        this.nullMarker = nullMarker;
    }

    public static NbcRowToken decode(ByteBuf buffer, Column[] columns) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Assert.requireNonNull(columns, "List of Columns must not be null");
        return NbcRowToken.doDecode(buffer, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, Column[] columns) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Assert.requireNonNull(columns, "List of Columns must not be null");
        int readerIndex = buffer.readerIndex();
        int nullBitmapSize = NbcRowToken.getNullBitmapSize(columns);
        try {
            if (buffer.readableBytes() < nullBitmapSize) {
                boolean bl = false;
                return bl;
            }
            boolean[] nullBitmap = NbcRowToken.getNullBitmap(buffer, columns);
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                if (nullBitmap[i] || NbcRowToken.canDecodeColumn(buffer, column)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    @Override
    public ByteBuf getColumnData(int index) {
        return this.nullMarker[index] ? null : super.getColumnData(index);
    }

    private static NbcRowToken doDecode(ByteBuf buffer, Column[] columns) {
        ByteBuf[] data = new ByteBuf[columns.length];
        boolean[] nullMarkers = NbcRowToken.getNullBitmap(buffer, columns);
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            data[i] = nullMarkers[i] ? Unpooled.EMPTY_BUFFER : NbcRowToken.decodeColumnData(buffer, column);
        }
        return new NbcRowToken(data, nullMarkers);
    }

    private static boolean[] getNullBitmap(ByteBuf buffer, Column[] columns) {
        int nullBitmapSize = NbcRowToken.getNullBitmapSize(columns);
        boolean[] nullMarkers = new boolean[columns.length];
        int column = 0;
        for (int byteNo = 0; byteNo < nullBitmapSize; ++byteNo) {
            byte byteValue = Decode.asByte(buffer);
            if (byteValue == 0) {
                column += 8;
                continue;
            }
            for (int bitNo = 0; bitNo < 8 && column < columns.length; ++column, ++bitNo) {
                if ((byteValue & 1 << bitNo) == 0) continue;
                nullMarkers[column] = true;
            }
        }
        return nullMarkers;
    }

    private static int getNullBitmapSize(Column[] columns) {
        return (columns.length - 1 >> 3) + 1;
    }

    @Override
    public String getName() {
        return "NBCROW";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" [nullMarker=").append(Arrays.toString(this.nullMarker));
        sb.append(']');
        return sb.toString();
    }
}

