/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.PlpEncoded;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.message.ClientMessage;
import io.r2dbc.mssql.message.TransactionDescriptor;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.message.tds.TdsPackets;
import io.r2dbc.mssql.message.token.AllHeaders;
import io.r2dbc.mssql.message.token.TokenStream;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class RpcRequest
implements ClientMessage,
TokenStream {
    static final HeaderOptions HEADER = HeaderOptions.create(Type.RPC, Status.empty());
    public static final short Sp_Cursor = 1;
    public static final short Sp_CursorOpen = 2;
    public static final short Sp_CursorPrepare = 3;
    public static final short Sp_CursorExecute = 4;
    public static final short Sp_CursorPrepExec = 5;
    public static final short Sp_CursorUnprepare = 6;
    public static final short Sp_CursorFetch = 7;
    public static final short Sp_CursorOption = 8;
    public static final short Sp_CursorClose = 9;
    public static final short Sp_ExecuteSql = 10;
    public static final short Sp_Prepare = 11;
    public static final short Sp_Execute = 12;
    public static final short Sp_PrepExec = 13;
    public static final short Sp_PrepExecRpc = 14;
    public static final short Sp_Unprepare = 15;
    private static final short PROC_ID_SWITCH = -1;
    private final AllHeaders allHeaders;
    @Nullable
    private final String procName;
    private final Integer procId;
    private final OptionFlags optionFlags;
    private final byte statusFlags;
    private final List<ParameterDescriptor> parameterDescriptors;

    private RpcRequest(AllHeaders allHeaders, @Nullable String procName, @Nullable Integer procId, OptionFlags optionFlags, byte statusFlags, List<ParameterDescriptor> parameterDescriptors) {
        this.allHeaders = Assert.requireNonNull(allHeaders, "AllHeaders must not be null");
        this.procName = procName;
        this.procId = procId;
        this.optionFlags = Assert.requireNonNull(optionFlags, "Option flags must not be null");
        this.statusFlags = statusFlags;
        this.parameterDescriptors = parameterDescriptors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Publisher<TdsFragment> encode(ByteBufAllocator allocator, int packetSize) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        return Flux.defer(() -> {
            int name = 2 + (this.procName != null ? this.procName.length() * 2 : 0);
            int length = 4 + name + this.allHeaders.getLength();
            for (ParameterDescriptor descriptor : this.parameterDescriptors) {
                length += descriptor.estimateLength();
            }
            ByteBuf scalarBuffer = allocator.buffer(length);
            this.encodeHeader(scalarBuffer);
            boolean hasPlpSegments = false;
            for (ParameterDescriptor descriptor : this.parameterDescriptors) {
                if (!(descriptor instanceof EncodedRpcParameter) || !(((EncodedRpcParameter)descriptor).getValue() instanceof PlpEncoded)) continue;
                hasPlpSegments = true;
            }
            if (!hasPlpSegments) {
                for (ParameterDescriptor descriptor : this.parameterDescriptors) {
                    descriptor.encode(scalarBuffer);
                }
                return Flux.just((Object)TdsPackets.create(HEADER, scalarBuffer));
            }
            AtomicReference<ByteBuf> firstBufferHolder = new AtomicReference<ByteBuf>(scalarBuffer);
            AtomicBoolean first = new AtomicBoolean(true);
            return Flux.fromIterable(this.parameterDescriptors).concatMap(it -> {
                ByteBuf buffer = this.getByteBuf(firstBufferHolder, allocator, (ParameterDescriptor)it);
                if (it instanceof EncodedRpcParameter && ((EncodedRpcParameter)it).getValue() instanceof PlpEncoded) {
                    EncodedRpcParameter parameter = (EncodedRpcParameter)it;
                    PlpEncoded encoded = (PlpEncoded)parameter.getValue();
                    parameter.encodeHeader(buffer);
                    encoded.encodeHeader(buffer);
                    AtomicReference<ByteBuf> firstChunk = new AtomicReference<ByteBuf>(buffer);
                    Flux tdsFragments = encoded.chunked(() -> packetSize * 4, true).map(chunk -> {
                        if (firstChunk.compareAndSet(buffer, null)) {
                            CompositeByteBuf withInitialBuffer = allocator.compositeBuffer();
                            withInitialBuffer.addComponent(true, buffer);
                            withInitialBuffer.addComponent(true, chunk);
                            return withInitialBuffer;
                        }
                        return chunk;
                    });
                    return tdsFragments.concatWith((Publisher)Mono.create(sink -> {
                        ByteBuf terminator = allocator.buffer();
                        Encode.asInt(terminator, 0);
                        sink.success((Object)terminator);
                    }));
                }
                it.encode(buffer);
                return Mono.just((Object)buffer);
            }, 1).map(buf -> {
                if (first.compareAndSet(true, false)) {
                    return TdsPackets.first(HEADER, buf);
                }
                return TdsPackets.create(buf);
            }).concatWith((Publisher)Mono.create(sink -> {
                ByteBuf firstBuffer = firstBufferHolder.getAndSet(null);
                if (firstBuffer != null) {
                    sink.success((Object)TdsPackets.last(firstBuffer));
                    return;
                }
                sink.success((Object)TdsPackets.last(Unpooled.EMPTY_BUFFER));
            }));
        });
    }

    private ByteBuf getByteBuf(AtomicReference<ByteBuf> firstBufferHolder, ByteBufAllocator allocator, ParameterDescriptor it) {
        ByteBuf firstBuffer = firstBufferHolder.getAndSet(null);
        if (firstBuffer != null) {
            return firstBuffer;
        }
        int estimatedLength = it.estimateLength();
        return estimatedLength > 0 ? allocator.buffer(estimatedLength) : allocator.buffer();
    }

    private void encodeHeader(ByteBuf buffer) {
        this.allHeaders.encode(buffer);
        if (this.procId != null) {
            Encode.uShort(buffer, -1);
            Encode.uShort(buffer, this.procId);
        } else {
            Assert.state(this.procName != null, "ProcName must not be null if ProcId is not set.");
            Encode.unicodeStream(buffer, this.procName);
        }
        Encode.asByte(buffer, this.optionFlags.getValue());
        Encode.asByte(buffer, this.statusFlags);
    }

    @Nullable
    public String getProcName() {
        return this.procName;
    }

    public Integer getProcId() {
        return this.procId;
    }

    @Override
    public String getName() {
        return "RPCRequest";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RpcRequest)) {
            return false;
        }
        RpcRequest that = (RpcRequest)o;
        return this.statusFlags == that.statusFlags && Objects.equals(this.allHeaders, that.allHeaders) && Objects.equals(this.procName, that.procName) && Objects.equals(this.procId, that.procId) && Objects.equals(this.optionFlags, that.optionFlags) && Objects.equals(this.parameterDescriptors, that.parameterDescriptors);
    }

    public int hashCode() {
        return Objects.hash(this.allHeaders, this.procName, this.procId, this.optionFlags, this.statusFlags, this.parameterDescriptors);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" [procName='").append(this.procName).append('\'');
        sb.append(", procId=").append(this.procId);
        sb.append(", optionFlags=").append(this.optionFlags);
        sb.append(", statusFlags=").append(this.statusFlags);
        sb.append(", parameterDescriptors=").append(this.parameterDescriptors);
        sb.append(']');
        return sb.toString();
    }

    static class EncodedRpcParameter
    extends ParameterDescriptor {
        private final Encoded value;

        EncodedRpcParameter(RpcDirection direction, @Nullable String name, Encoded value) {
            super(direction, name);
            this.value = value;
        }

        public Encoded getValue() {
            return this.value;
        }

        @Override
        void encode(ByteBuf buffer) {
            this.encodeHeader(buffer);
            buffer.writeBytes(this.value.getValue());
            this.value.release();
        }

        void encodeHeader(ByteBuf buffer) {
            RpcEncoding.encodeHeader(buffer, this.getName(), this.getDirection(), this.value.getDataType());
        }

        @Override
        int estimateLength() {
            int estimate = 2 + (this.getName() != null ? (this.getName().length() + 1) * 2 : 0);
            return estimate += this.value.getValue().readableBytes();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EncodedRpcParameter)) {
                return false;
            }
            EncodedRpcParameter encodedRpcParameter = (EncodedRpcParameter)o;
            return Objects.equals((Object)this.value, (Object)encodedRpcParameter.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value});
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [name='").append(this.getName()).append('\'');
            sb.append(", value=").append((Object)this.value);
            sb.append(']');
            return sb.toString();
        }
    }

    static class RpcInt
    extends ParameterDescriptor {
        @Nullable
        private final Integer value;

        RpcInt(RpcDirection direction, @Nullable String name, @Nullable Integer value) {
            super(direction, name);
            this.value = value;
        }

        @Override
        void encode(ByteBuf buffer) {
            RpcEncoding.encodeInteger(buffer, this.getName(), this.getDirection(), this.value);
        }

        @Override
        int estimateLength() {
            return this.value != null ? 5 : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RpcInt)) {
                return false;
            }
            RpcInt rpcInt = (RpcInt)o;
            return Objects.equals(this.value, rpcInt.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [name='").append(this.getName()).append('\'');
            sb.append(", value=").append(this.value);
            sb.append(']');
            return sb.toString();
        }
    }

    static class RpcString
    extends ParameterDescriptor {
        private final Collation collation;
        @Nullable
        private final String value;

        RpcString(RpcDirection direction, @Nullable String name, Collation collation, @Nullable String value) {
            super(direction, name);
            this.value = value;
            this.collation = collation;
        }

        @Override
        void encode(ByteBuf buffer) {
            RpcEncoding.encodeString(buffer, this.getName(), this.getDirection(), this.collation, this.value);
        }

        @Override
        int estimateLength() {
            return 16 + (this.value != null ? this.value.length() * 2 : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RpcString)) {
                return false;
            }
            RpcString rpcString = (RpcString)o;
            return Objects.equals(this.collation, rpcString.collation) && Objects.equals(this.value, rpcString.value);
        }

        public int hashCode() {
            return Objects.hash(this.collation, this.value);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [name='").append(this.getName()).append('\'');
            sb.append(", value=").append(this.value);
            sb.append(']');
            return sb.toString();
        }
    }

    static abstract class ParameterDescriptor {
        private final RpcDirection direction;
        @Nullable
        private final String name;

        ParameterDescriptor(RpcDirection direction, @Nullable String name) {
            this.direction = Assert.requireNonNull(direction, "Direction must not be null");
            this.name = name;
        }

        abstract void encode(ByteBuf var1);

        abstract int estimateLength();

        public RpcDirection getDirection() {
            return this.direction;
        }

        @Nullable
        public String getName() {
            return this.name;
        }
    }

    public static final class OptionFlags {
        private static final OptionFlags EMPTY = new OptionFlags(0);
        static final byte RPC_OPTION_RECOMPILE = 1;
        static final byte RPC_OPTION_NO_METADATA = 2;
        private final int optionByte;

        private OptionFlags(int optionByte) {
            this.optionByte = optionByte;
        }

        public static OptionFlags empty() {
            return EMPTY;
        }

        public OptionFlags enableRecompile() {
            return new OptionFlags(this.optionByte | 1);
        }

        public OptionFlags disableMetadata() {
            return new OptionFlags(this.optionByte | 2);
        }

        public byte getValue() {
            return (byte)this.optionByte;
        }
    }

    public static final class Builder {
        @Nullable
        private String procName;
        private Integer procId;
        private OptionFlags optionFlags = OptionFlags.empty();
        private byte statusFlags;
        private TransactionDescriptor transactionDescriptor;
        private List<ParameterDescriptor> parameterDescriptors = new ArrayList<ParameterDescriptor>();

        public Builder withProcName(String procName) {
            Assert.requireNonNull(procName, "ProcName must not be null");
            this.procId = null;
            this.procName = procName;
            return this;
        }

        public Builder withProcId(int id) {
            this.procName = null;
            this.procId = id;
            return this;
        }

        public Builder withParameter(RpcDirection direction, Collation collation, @Nullable String value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            Assert.requireNonNull(collation, "Collation must not be null");
            this.parameterDescriptors.add(new RpcString(direction, null, collation, value));
            return this;
        }

        public Builder withParameter(RpcDirection direction, @Nullable Integer value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            this.parameterDescriptors.add(new RpcInt(direction, null, value));
            return this;
        }

        public Builder withParameter(RpcDirection direction, Encoded value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            Assert.requireNonNull(value, "Encoded parameter name must not be null");
            this.parameterDescriptors.add(new EncodedRpcParameter(direction, null, value));
            return this;
        }

        public Builder withNamedParameter(RpcDirection direction, String name, Collation collation, @Nullable String value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            Assert.requireNonNull(name, "Parameter name must not be null");
            Assert.requireNonNull(collation, "Collation must not be null");
            this.parameterDescriptors.add(new RpcString(direction, name, collation, value));
            return this;
        }

        public Builder withNamedParameter(RpcDirection direction, String name, @Nullable Integer value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            Assert.requireNonNull(name, "Parameter name must not be null");
            this.parameterDescriptors.add(new RpcInt(direction, name, value));
            return this;
        }

        public Builder withNamedParameter(RpcDirection direction, String name, Encoded value) {
            Assert.requireNonNull(direction, "RPC direction (in/out) must not be null");
            Assert.requireNonNull(name, "Parameter name must not be null");
            Assert.requireNonNull(value, "Encoded parameter name must not be null");
            this.parameterDescriptors.add(new EncodedRpcParameter(direction, name, value));
            return this;
        }

        public Builder withTransactionDescriptor(TransactionDescriptor transactionDescriptor) {
            this.transactionDescriptor = Assert.requireNonNull(transactionDescriptor, "TransactionDescriptor must not be null");
            return this;
        }

        public Builder withOptionFlags(OptionFlags optionFlags) {
            this.optionFlags = Assert.requireNonNull(optionFlags, "OptionFlags must not be null");
            return this;
        }

        public RpcRequest build() {
            Assert.state(this.transactionDescriptor != null, "TransactionDescriptor is not configured");
            Assert.state(this.procName != null || this.procId != null, "Either procedure name or procedure Id required");
            return new RpcRequest(AllHeaders.transactional(this.transactionDescriptor.toBytes(), 1), this.procName, this.procId, this.optionFlags, this.statusFlags, new ArrayList<ParameterDescriptor>(this.parameterDescriptors));
        }
    }
}

