/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.MssqlColumnMetadata;
import io.r2dbc.mssql.NamedCollectionSupport;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.ColumnMetadataToken;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

final class MssqlRowMetadata
extends NamedCollectionSupport<Column>
implements RowMetadata,
Collection<String> {
    private final Codecs codecs;
    @Nullable
    private Map<Column, MssqlColumnMetadata> metadataCache;

    MssqlRowMetadata(Codecs codecs, Column[] columns, Map<String, Column> nameKeyedColumns) {
        super(columns, nameKeyedColumns, Column::getName, "column");
        this.codecs = Assert.requireNonNull(codecs, "Codecs must not be null");
    }

    public static MssqlRowMetadata create(Codecs codecs, ColumnMetadataToken columnMetadata) {
        Assert.notNull((Object)columnMetadata, "ColumnMetadata must not be null");
        return new MssqlRowMetadata(codecs, columnMetadata.getColumns(), columnMetadata.toMap());
    }

    public MssqlColumnMetadata getColumnMetadata(int index) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent((Column)this.get(index), column -> new MssqlColumnMetadata((Decodable)column, this.codecs));
    }

    public MssqlColumnMetadata getColumnMetadata(String identifier) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent((Column)this.get(identifier), column -> new MssqlColumnMetadata((Decodable)column, this.codecs));
    }

    public List<MssqlColumnMetadata> getColumnMetadatas() {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<Column, MssqlColumnMetadata>();
        }
        ArrayList<MssqlColumnMetadata> metadatas = new ArrayList<MssqlColumnMetadata>(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            MssqlColumnMetadata columnMetadata = this.metadataCache.computeIfAbsent((Column)this.get(i), column -> new MssqlColumnMetadata((Decodable)column, this.codecs));
            metadatas.add(columnMetadata);
        }
        return metadatas;
    }

    public boolean contains(String columnName) {
        return this.find(columnName) != null;
    }
}

