/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractInfoToken;

public final class ErrorToken
extends AbstractInfoToken {
    public static final byte TYPE = -86;

    public ErrorToken(long length, long number, int state, int infoClass, String message, String serverName, String procName, long lineNumber) {
        super((byte)-86, length, number, (byte)state, (byte)infoClass, message, serverName, procName, lineNumber);
    }

    public ErrorToken(long length, long number, byte state, byte infoClass, String message, String serverName, String procName, long lineNumber) {
        super((byte)-86, length, number, state, infoClass, message, serverName, procName, lineNumber);
    }

    public static ErrorToken decode(ByteBuf buffer) {
        int length = Decode.uShort(buffer);
        long number = Decode.asLong(buffer);
        byte state = Decode.asByte(buffer);
        byte infoClass = Decode.asByte(buffer);
        String msgText = Decode.unicodeUString(buffer);
        String serverName = Decode.unicodeBString(buffer);
        String procName = Decode.unicodeBString(buffer);
        long lineNumber = buffer.readUnsignedInt();
        return new ErrorToken((long)length, number, state, infoClass, msgText, serverName, procName, lineNumber);
    }

    @Override
    public String getName() {
        return "ERROR";
    }
}

