/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.nio.charset.Charset;
import reactor.util.annotation.Nullable;

final class MutableTypeInformation
implements TypeInformation {
    int maxLength;
    LengthStrategy lengthStrategy;
    int precision;
    int displaySize;
    int scale;
    int flags;
    SqlServerType serverType;
    int userType;
    @Nullable
    String udtTypeName;
    @Nullable
    Collation collation;
    @Nullable
    Charset charset;

    MutableTypeInformation() {
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public LengthStrategy getLengthStrategy() {
        return this.lengthStrategy;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        return this.displaySize;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public SqlServerType getServerType() {
        return this.serverType;
    }

    @Override
    public int getUserType() {
        return this.userType;
    }

    @Override
    @Nullable
    public String getUdtTypeName() {
        return this.udtTypeName;
    }

    @Override
    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getServerTypeName() {
        return SqlServerType.UDT == this.serverType ? this.udtTypeName : this.serverType.toString();
    }

    @Override
    public boolean isNullable() {
        return 1 == (this.flags & 1);
    }

    @Override
    public boolean isCaseSensitive() {
        return 2 == (this.flags & 2);
    }

    @Override
    public boolean isSparseColumnSet() {
        return 1024 == (this.flags & 0x400);
    }

    @Override
    public boolean isEncrypted() {
        return 2048 == (this.flags & 0x800);
    }

    @Override
    public TypeInformation.Updatability getUpdatability() {
        int value = this.flags >> 2 & 3;
        if (value == 0) {
            return TypeInformation.Updatability.READ_ONLY;
        }
        if (value == 1) {
            return TypeInformation.Updatability.READ_WRITE;
        }
        return TypeInformation.Updatability.UNKNOWN;
    }

    @Override
    public boolean isIdentity() {
        return 16 == (this.flags & 0x10);
    }

    private byte[] getFlags() {
        byte[] f = new byte[]{(byte)(this.flags & 0xFF), (byte)(this.flags >> 8 & 0xFF)};
        return f;
    }

    public boolean supportsFastAsciiConversion() {
        switch (this.serverType) {
            case CHAR: 
            case VARCHAR: 
            case VARCHARMAX: 
            case TEXT: {
                return this.collation != null && this.collation.hasAsciiCompatibleSBCS();
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [maxLength=").append(this.maxLength);
        sb.append(", lengthStrategy=").append((Object)this.lengthStrategy);
        sb.append(", precision=").append(this.precision);
        sb.append(", displaySize=").append(this.displaySize);
        sb.append(", scale=").append(this.scale);
        sb.append(", flags=").append(this.flags);
        sb.append(", serverType=").append((Object)this.serverType);
        sb.append(", userType=").append(this.userType);
        sb.append(", udtTypeName=\"").append(this.udtTypeName).append('\"');
        sb.append(", collation=").append(this.collation);
        sb.append(", charset=").append(this.charset);
        sb.append(']');
        return sb.toString();
    }
}

