/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractNumericCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.DecimalCodec;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.math.BigDecimal;
import java.math.BigInteger;

final class BigIntegerCodec
extends AbstractNumericCodec<BigInteger> {
    static final BigIntegerCodec INSTANCE = new BigIntegerCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.BIGINT));

    private BigIntegerCodec() {
        super(BigInteger.class, BigInteger::valueOf);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, BigInteger value) {
        return DecimalCodec.INSTANCE.encode(allocator, context, new BigDecimal(value));
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.BIGINT);
    }

    @Override
    BigInteger doDecode(ByteBuf buffer, Length length, TypeInformation typeInformation, Class<? extends BigInteger> valueType) {
        if (typeInformation.getServerType() == SqlServerType.NUMERIC || typeInformation.getServerType() == SqlServerType.DECIMAL) {
            Object decimal = DecimalCodec.INSTANCE.doDecode(buffer, length, typeInformation, BigDecimal.class);
            if (decimal == null) {
                return null;
            }
            return ((BigDecimal)decimal).toBigInteger();
        }
        return super.doDecode(buffer, length, typeInformation, valueType);
    }
}

