/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractNumericCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.SqlServerType;

final class LongCodec
extends AbstractNumericCodec<Long> {
    static final LongCodec INSTANCE = new LongCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.BIGINT));

    private LongCodec() {
        super(Long.class, value -> value);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, Long value) {
        return RpcEncoding.encodeFixed(allocator, SqlServerType.BIGINT, value, Encode::bigint);
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.BIGINT);
    }
}

