/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.CharacterEncoder;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.StringUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

public final class RpcEncoding {
    private RpcEncoding() {
    }

    public static void encodeString(ByteBuf buffer, @Nullable String name, RpcDirection direction, Collation collation, @Nullable String value) {
        RpcEncoding.encodeHeader(buffer, name, direction, TdsDataType.NVARCHAR);
        CharacterEncoder.encodeBigVarchar(buffer, direction, collation, true, value);
    }

    public static void encodeInteger(ByteBuf buffer, @Nullable String name, RpcDirection direction, @Nullable Integer value) {
        RpcEncoding.encodeHeader(buffer, name, direction, TdsDataType.INTN);
        Encode.asByte(buffer, 4);
        if (value == null) {
            Encode.asByte(buffer, 0);
        } else {
            Encode.asByte(buffer, 4);
            Encode.asInt(buffer, value);
        }
    }

    public static void encodeHeader(ByteBuf buffer, @Nullable String name, RpcDirection direction, TdsDataType dataType) {
        if (StringUtils.hasText(name)) {
            Encode.asByte(buffer, name.length() + 1);
            char at = '@';
            RpcEncoding.writeChar(buffer, at);
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                RpcEncoding.writeChar(buffer, ch);
            }
        } else {
            Encode.asByte(buffer, 0);
        }
        Encode.asByte(buffer, direction == RpcDirection.OUT ? 1 : 0);
        Encode.asByte(buffer, dataType.getValue());
    }

    private static void writeChar(ByteBuf buffer, char ch) {
        buffer.writeByte((int)((byte)(ch & 0xFF)));
        buffer.writeByte((int)((byte)(ch >> 8 & 0xFF)));
    }

    public static <T> Encoded encodeFixed(ByteBufAllocator allocator, SqlServerType serverType, T value, BiConsumer<ByteBuf, T> valueEncoder) {
        Assert.notNull((Object)serverType.getNullableType(), "Server type provides no nullable type");
        LengthStrategy lengthStrategy = serverType.getNullableType().getLengthStrategy();
        return new HintedEncoded(serverType.getNullableType(), serverType, () -> {
            ByteBuf buffer = RpcEncoding.prepareBuffer(allocator, lengthStrategy, serverType.getMaxLength(), serverType.getMaxLength());
            valueEncoder.accept(buffer, value);
            return buffer;
        });
    }

    public static <T> Encoded encode(ByteBufAllocator allocator, SqlServerType serverType, int length, T value, BiConsumer<ByteBuf, T> valueEncoder) {
        Assert.notNull((Object)serverType.getNullableType(), "Server type provides no nullable type");
        TdsDataType dataType = serverType.getNullableType();
        return new HintedEncoded(dataType, serverType, () -> {
            ByteBuf buffer = RpcEncoding.prepareBuffer(allocator, dataType.getLengthStrategy(), serverType.getMaxLength(), length);
            valueEncoder.accept(buffer, value);
            return buffer;
        });
    }

    public static Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        Assert.notNull((Object)serverType.getNullableType(), "Server type does not declare a nullable type");
        return new HintedEncoded(serverType.getNullableType(), serverType, () -> RpcEncoding.prepareBuffer(allocator, serverType.getNullableType().getLengthStrategy(), serverType.getMaxLength(), 0));
    }

    public static Encoded wrap(byte[] buffer, SqlServerType serverType) {
        Assert.isTrue(serverType.getMaxLength() > 0, "Server type does not declare a max length");
        Assert.notNull((Object)serverType.getNullableType(), "Server type does not declare a nullable type");
        return new HintedEncoded(serverType.getNullableType(), serverType, () -> Unpooled.wrappedBuffer((byte[])buffer));
    }

    public static Encoded encodeTemporalNull(ByteBufAllocator allocator, SqlServerType serverType) {
        Assert.notNull((Object)serverType.getNullableType(), "Server type does not declare a nullable type");
        return new HintedEncoded(serverType.getNullableType(), serverType, () -> {
            ByteBuf buffer = allocator.buffer(1);
            Encode.asByte(buffer, 0);
            return buffer;
        });
    }

    public static Encoded encodeTemporalNull(ByteBufAllocator allocator, SqlServerType serverType, int scale) {
        Assert.notNull((Object)serverType.getNullableType(), "Server type does not declare a nullable type");
        return new HintedEncoded(serverType.getNullableType(), serverType, () -> {
            ByteBuf buffer = allocator.buffer(1);
            Encode.asByte(buffer, scale);
            Encode.asByte(buffer, 0);
            return buffer;
        });
    }

    static ByteBuf prepareBuffer(ByteBufAllocator allocator, LengthStrategy lengthStrategy, int maxLength, int length) {
        switch (lengthStrategy) {
            case PARTLENTYPE: {
                ByteBuf buffer = allocator.buffer(16 + length);
                buffer.writeLong((long)maxLength).writeLong((long)length);
                return buffer;
            }
            case BYTELENTYPE: {
                ByteBuf buffer = allocator.buffer(2 + length);
                Encode.asByte(buffer, maxLength);
                Encode.asByte(buffer, length);
                return buffer;
            }
            case FIXEDLENTYPE: {
                ByteBuf buffer = allocator.buffer();
                return buffer;
            }
            case USHORTLENTYPE: {
                ByteBuf buffer = allocator.buffer(2 + length);
                Encode.uShort(buffer, maxLength);
                Encode.uShort(buffer, length);
                return buffer;
            }
        }
        throw new UnsupportedOperationException(lengthStrategy.toString());
    }

    static class HintedEncoded
    extends Encoded {
        private final SqlServerType sqlServerType;

        public HintedEncoded(TdsDataType dataType, SqlServerType sqlServerType, Supplier<ByteBuf> value) {
            super(dataType, value);
            this.sqlServerType = sqlServerType;
        }

        @Override
        public String getFormalType() {
            return this.sqlServerType.toString();
        }
    }
}

