/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.tds;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.ServerCharset;
import reactor.util.annotation.Nullable;

public final class Decode {
    private Decode() {
    }

    public static byte asByte(ByteBuf buffer) {
        return buffer.readByte();
    }

    public static int uByte(ByteBuf buffer) {
        return buffer.readUnsignedByte();
    }

    public static long dword(ByteBuf buffer) {
        return buffer.readUnsignedIntLE();
    }

    public static byte bit(ByteBuf buffer) {
        return Decode.asByte(buffer);
    }

    public static float asFloat(ByteBuf buffer) {
        return Float.intBitsToFloat(buffer.readIntLE());
    }

    public static double asDouble(ByteBuf buffer) {
        return Double.longBitsToDouble(buffer.readLongLE());
    }

    public static byte tinyInt(ByteBuf buffer) {
        return Decode.asByte(buffer);
    }

    public static short smallInt(ByteBuf buffer) {
        return buffer.readShortLE();
    }

    public static int asInt(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    public static long bigint(ByteBuf buffer) {
        return buffer.readLongLE();
    }

    public static int asLong(ByteBuf buffer) {
        return buffer.readIntLE();
    }

    public static long uLongLong(ByteBuf buffer) {
        return buffer.readLongLE();
    }

    public static int uShort(ByteBuf buffer) {
        return buffer.readUnsignedShortLE();
    }

    @Nullable
    public static Integer peekUShort(ByteBuf buffer) {
        if (buffer.readableBytes() >= 2) {
            buffer.markReaderIndex();
            int peek = Decode.uShort(buffer);
            buffer.resetReaderIndex();
            return peek;
        }
        return null;
    }

    public static int intBigEndian(ByteBuf buffer) {
        return buffer.readInt();
    }

    public static String unicodeUString(ByteBuf buffer) {
        int length = buffer.readUnsignedShortLE() * 2;
        return Decode.decodeUnicode(buffer, length);
    }

    public static String unicodeBString(ByteBuf buffer) {
        int length = buffer.readByte() * 2;
        return Decode.decodeUnicode(buffer, length);
    }

    private static String decodeUnicode(ByteBuf buffer, int length) {
        String result = buffer.toString(buffer.readerIndex(), length, ServerCharset.UNICODE.charset());
        buffer.skipBytes(length);
        return result;
    }
}

