/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;

public abstract class AbstractInfoToken
extends AbstractDataToken {
    private final long length;
    private final long number;
    private final byte state;
    private final byte infoClass;
    private final Classification classification;
    private final String message;
    private final String serverName;
    private final String procName;
    private final long lineNumber;

    AbstractInfoToken(byte type, long length, long number, byte state, byte infoClass, String message, String serverName, String procName, long lineNumber) {
        super(type);
        this.length = length;
        this.number = number;
        this.state = state;
        this.infoClass = infoClass;
        this.classification = Classification.valueOf(this.infoClass);
        this.message = message;
        this.serverName = serverName;
        this.procName = procName;
        this.lineNumber = lineNumber;
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Integer requiredLength = Decode.peekUShort(buffer);
        return requiredLength != null && buffer.readableBytes() >= requiredLength + 2;
    }

    public long getNumber() {
        return this.number;
    }

    public byte getState() {
        return this.state;
    }

    public byte getInfoClass() {
        return this.infoClass;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public String getMessage() {
        return this.message;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getProcName() {
        return this.procName;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [number=").append(this.number);
        sb.append(", state=").append(this.state);
        sb.append(", infoClass=").append(this.infoClass);
        sb.append(", message='").append(this.message).append('\"');
        sb.append(", serverName='").append(this.serverName).append('\"');
        sb.append(", procName='").append(this.procName).append('\"');
        sb.append(", lineNumber=").append(this.lineNumber);
        sb.append(']');
        return sb.toString();
    }

    public static enum Classification {
        INFORMATIONAL(0, 10),
        OBJECT_DOES_NOT_EXIST(11),
        INCONSISTENT_NO_LOCK(12),
        TX_DEADLOCK(13),
        SECURITY(14),
        SYNTAX_ERROR(15),
        GENERAL_ERROR(16),
        OUT_OF_RESOURCES(17),
        DATABASE_ENGINE_FAILURE(18),
        DATABASE_LIMIT(19),
        SYSTEM_SQL_PROBLEM(20),
        ALL_TASKS_PROBLEM(21),
        INDEX_PROBLEM(22),
        DATABASE_INTEGRITY_PROBLEM(23),
        MEDIA_ERROR(24),
        UNKNOWN(-1);

        final int from;
        final int to;

        private Classification(int code) {
            this(code, code);
        }

        private Classification(int from, int to) {
            this.from = from;
            this.to = to;
        }

        static Classification valueOf(int value) {
            for (Classification classification : Classification.values()) {
                if (value < classification.from || value > classification.to) continue;
                return classification;
            }
            return UNKNOWN;
        }
    }
}

