/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.postgresql.OptionMapper;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.extension.Extension;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import reactor.netty.resources.LoopResources;

public final class PostgresqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final Option<String> APPLICATION_NAME = Option.valueOf((String)"applicationName");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");
    public static final Option<Boolean> COMPATIBILITY_MODE = Option.valueOf((String)"compatibilityMode");
    public static final Option<Collection<Extension>> EXTENSIONS = Option.valueOf((String)"extensions");
    public static final Option<Integer> FETCH_SIZE = Option.valueOf((String)"fetchSize");
    public static final Option<Boolean> FORCE_BINARY = Option.valueOf((String)"forceBinary");
    public static final Option<Duration> LOCK_WAIT_TIMEOUT = Option.valueOf((String)"lockWaitTimeout");
    public static final Option<LoopResources> LOOP_RESOURCES = Option.valueOf((String)"loopResources");
    public static final Option<Map<String, String>> OPTIONS = Option.valueOf((String)"options");
    public static final String POSTGRESQL_DRIVER = "postgresql";
    public static final String LEGACY_POSTGRESQL_DRIVER = "postgres";
    public static final Option<Boolean> PREFER_ATTACHED_BUFFERS = Option.valueOf((String)"preferAttachedBuffers");
    public static final Option<Integer> PREPARED_STATEMENT_CACHE_QUERIES = Option.valueOf((String)"preparedStatementCacheQueries");
    public static final Option<String> SCHEMA = Option.valueOf((String)"schema");
    public static final Option<String> CURRENT_SCHEMA = Option.valueOf((String)"currentSchema");
    public static final Option<String> SOCKET = Option.valueOf((String)"socket");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<SSLMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<String> SSL_PASSWORD = Option.valueOf((String)"sslPassword");
    public static final Option<String> SSL_ROOT_CERT = Option.valueOf((String)"sslRootCert");
    public static final Option<Duration> STATEMENT_TIMEOUT = Option.valueOf((String)"statementTimeout");
    public static final Option<Boolean> TCP_KEEPALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NODELAY = Option.valueOf((String)"tcpNoDelay");

    public static PostgresqlConnectionConfiguration.Builder builder(ConnectionFactoryOptions connectionFactoryOptions) {
        return PostgresqlConnectionFactoryProvider.fromConnectionFactoryOptions(connectionFactoryOptions);
    }

    public PostgresqlConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new PostgresqlConnectionFactory(PostgresqlConnectionFactoryProvider.builder(connectionFactoryOptions).build());
    }

    public String getDriver() {
        return POSTGRESQL_DRIVER;
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return driver != null && (driver.equals(POSTGRESQL_DRIVER) || driver.equals(LEGACY_POSTGRESQL_DRIVER));
    }

    private static PostgresqlConnectionConfiguration.Builder fromConnectionFactoryOptions(ConnectionFactoryOptions options) {
        Assert.requireNonNull(options, "connectionFactoryOptions must not be null");
        PostgresqlConnectionConfiguration.Builder builder = PostgresqlConnectionConfiguration.builder();
        OptionMapper mapper = OptionMapper.create(options);
        mapper.from(APPLICATION_NAME).to(builder::applicationName);
        mapper.from(AUTODETECT_EXTENSIONS).map(OptionMapper::toBoolean).to(builder::autodetectExtensions);
        mapper.from(COMPATIBILITY_MODE).map(OptionMapper::toBoolean).to(builder::compatibilityMode);
        mapper.from(ConnectionFactoryOptions.CONNECT_TIMEOUT).map(OptionMapper::toDuration).to(builder::connectTimeout);
        mapper.from(CURRENT_SCHEMA).to(builder::schema).otherwise(() -> mapper.from(SCHEMA).to(builder::schema));
        mapper.from(ConnectionFactoryOptions.DATABASE).to(builder::database);
        mapper.from(EXTENSIONS).to(extensions -> extensions.forEach(builder::extendWith));
        mapper.from(FETCH_SIZE).map(OptionMapper::toInteger).to(builder::fetchSize);
        mapper.from(FORCE_BINARY).map(OptionMapper::toBoolean).to(builder::forceBinary);
        mapper.from(LOCK_WAIT_TIMEOUT).map(OptionMapper::toDuration).to(builder::lockWaitTimeout);
        mapper.from(LOOP_RESOURCES).to(builder::loopResources);
        mapper.from(OPTIONS).map(PostgresqlConnectionFactoryProvider::convertToMap).to(builder::options);
        mapper.from(ConnectionFactoryOptions.PASSWORD).to(builder::password);
        mapper.from(ConnectionFactoryOptions.PORT).map(OptionMapper::toInteger).to(builder::port);
        mapper.from(PREFER_ATTACHED_BUFFERS).map(OptionMapper::toBoolean).to(builder::preferAttachedBuffers);
        mapper.from(PREPARED_STATEMENT_CACHE_QUERIES).map(OptionMapper::toInteger).to(builder::preparedStatementCacheQueries);
        mapper.from(SOCKET).to(builder::socket).otherwise(() -> {
            builder.host((String)options.getRequiredValue(ConnectionFactoryOptions.HOST));
            PostgresqlConnectionFactoryProvider.setupSsl(builder, mapper);
        });
        mapper.from(STATEMENT_TIMEOUT).map(OptionMapper::toDuration).to(builder::statementTimeout);
        mapper.from(TCP_KEEPALIVE).map(OptionMapper::toBoolean).to(builder::tcpKeepAlive);
        mapper.from(TCP_NODELAY).map(OptionMapper::toBoolean).to(builder::tcpNoDelay);
        builder.username((String)options.getRequiredValue(ConnectionFactoryOptions.USER));
        return builder;
    }

    private static void setupSsl(PostgresqlConnectionConfiguration.Builder builder, OptionMapper mapper) {
        mapper.from(ConnectionFactoryOptions.SSL).map(OptionMapper::toBoolean).to(enableSsl -> {
            if (enableSsl.booleanValue()) {
                builder.enableSsl();
            }
        });
        mapper.from(SSL_MODE).map(it -> {
            if (it instanceof String) {
                return SSLMode.fromValue(it.toString());
            }
            return (SSLMode)((Object)((Object)it));
        }).to(builder::sslMode);
        mapper.from(SSL_CERT).to(builder::sslCert);
        mapper.from(SSL_CONTEXT_BUILDER_CUSTOMIZER).to(builder::sslContextBuilderCustomizer);
        mapper.from(SSL_KEY).to(builder::sslKey);
        mapper.from(SSL_ROOT_CERT).to(builder::sslRootCert);
        mapper.from(SSL_PASSWORD).to(builder::sslPassword);
        mapper.from(SSL_HOSTNAME_VERIFIER).map(it -> {
            if (it instanceof String) {
                try {
                    Class<?> verifierClass = Class.forName((String)it);
                    Object verifier = verifierClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return (HostnameVerifier)verifier;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Cannot instantiate " + it, e);
                }
            }
            return (HostnameVerifier)it;
        }).to(builder::sslHostnameVerifier);
    }

    private static Map<String, String> convertToMap(Object options) {
        if (options instanceof Map) {
            return (Map)Map.class.cast(options);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : options.toString().split(";")) {
            String[] items = pair.split("=");
            if (items.length != 2) {
                throw new IllegalArgumentException(String.format("Provided options pair is not a valid name=value pair: %s", pair));
            }
            result.put(items[0], items[1]);
        }
        return result;
    }
}

