/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.ZonedDateTime;
import reactor.util.annotation.Nullable;

final class ZonedDateTimeCodec
extends AbstractTemporalCodec<ZonedDateTime> {
    private final ByteBufAllocator byteBufAllocator;

    ZonedDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(ZonedDateTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return ZonedDateTimeCodec.createNull(PostgresqlObjectId.TIMESTAMPTZ, Format.FORMAT_TEXT);
    }

    @Override
    ZonedDateTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<? extends ZonedDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, ZonedDateTime.class, ZonedDateTime::from);
    }

    @Override
    Parameter doEncode(ZonedDateTime value) {
        Assert.requireNonNull(value, "value must not be null");
        return ZonedDateTimeCodec.create(PostgresqlObjectId.TIMESTAMPTZ, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toOffsetDateTime().toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

