/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.NumericDecodeUtils;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.math.BigDecimal;
import java.util.function.Supplier;

final class BigDecimalArrayCodec
extends AbstractArrayCodec<BigDecimal> {
    public BigDecimalArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, BigDecimal.class);
    }

    @Override
    public Parameter encodeNull() {
        return BigDecimalArrayCodec.createNull(PostgresqlObjectId.NUMERIC_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.NUMERIC_ARRAY == type;
    }

    @Override
    BigDecimal doDecodeBinary(ByteBuf byteBuffer) {
        return NumericDecodeUtils.decodeBinary(byteBuffer);
    }

    @Override
    BigDecimal doDecodeText(String text) {
        return new BigDecimal(text);
    }

    @Override
    String doEncodeText(BigDecimal value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return BigDecimalArrayCodec.create(PostgresqlObjectId.NUMERIC_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }
}

