/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class BooleanCodec
extends AbstractCodec<Boolean> {
    private final ByteBufAllocator byteBufAllocator;

    BooleanCodec(ByteBufAllocator byteBufAllocator) {
        super(Boolean.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return BooleanCodec.createNull(PostgresqlObjectId.BOOL, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BOOL == type;
    }

    @Override
    Boolean doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Boolean> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        if (format == Format.FORMAT_BINARY) {
            return buffer.readBoolean();
        }
        String decoded = ByteBufUtils.decode(buffer);
        return "1".equals(decoded) || "true".equalsIgnoreCase(decoded) || "t".equalsIgnoreCase(decoded) || "yes".equalsIgnoreCase(decoded) || "y".equalsIgnoreCase(decoded) || "on".equalsIgnoreCase(decoded);
    }

    @Override
    Parameter doEncode(Boolean value) {
        Assert.requireNonNull(value, "value must not be null");
        return BooleanCodec.create(PostgresqlObjectId.BOOL, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value != false ? "TRUE" : "FALSE"));
    }
}

