/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class LongArrayCodec
extends AbstractArrayCodec<Long> {
    LongArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Long.class);
    }

    @Override
    public Parameter encodeNull() {
        return LongArrayCodec.createNull(PostgresqlObjectId.INT8_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    Long doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readLong();
    }

    @Override
    Long doDecodeText(String text) {
        return Long.parseLong(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.INT8_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return LongArrayCodec.create(PostgresqlObjectId.INT8_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Long value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

