/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

final class ShortArrayCodec
extends AbstractArrayCodec<Short> {
    ShortArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Short.class);
    }

    @Override
    public Parameter encodeNull() {
        return ShortArrayCodec.createNull(PostgresqlObjectId.INT2_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    Short doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readShort();
    }

    @Override
    Short doDecodeText(String text) {
        return Short.parseShort(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, @Nullable Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.INT2_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return ShortArrayCodec.create(PostgresqlObjectId.INT2_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Short value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

