/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableStatementInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.MethodExecutionInfo;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Statement;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public final class ConnectionCallbackHandler
extends CallbackHandlerSupport {
    private final Connection connection;
    private final ConnectionInfo connectionInfo;

    public ConnectionCallbackHandler(Connection connection, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.connection = Assert.requireNonNull(connection, "connection must not be null");
        this.connectionInfo = Assert.requireNonNull(connectionInfo, "connectionInfo must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        if (this.isCommonMethod(methodName)) {
            return this.handleCommonMethod(methodName, this.connection, args, this.connection);
        }
        Consumer<MethodExecutionInfo> onComplete = null;
        if ("beginTransaction".equals(methodName)) {
            onComplete = executionInfo -> executionInfo.getConnectionInfo().incrementTransactionCount();
        } else if ("commitTransaction".equals(methodName)) {
            onComplete = executionInfo -> executionInfo.getConnectionInfo().incrementCommitCount();
        } else if ("rollbackTransaction".equals(methodName)) {
            onComplete = executionInfo -> executionInfo.getConnectionInfo().incrementRollbackCount();
        } else if ("close".equals(methodName)) {
            onComplete = executionInfo -> executionInfo.getConnectionInfo().setClosed(true);
        }
        if ("createStatement".equals(methodName)) {
            String query = (String)args[0];
            MutableStatementInfo statementInfo = new MutableStatementInfo();
            statementInfo.setConnectionInfo(this.connectionInfo);
            statementInfo.setOriginalQuery(query);
            String updatedQuery = this.proxyConfig.getBindParameterConverter().onCreateStatement(query, statementInfo);
            statementInfo.setUpdatedQuery(updatedQuery);
            args[0] = updatedQuery;
            Object result = this.proceedExecution(method, this.connection, args, this.proxyConfig.getListeners(), this.connectionInfo, null);
            return this.proxyConfig.getProxyFactory().wrapStatement((Statement)result, statementInfo, this.connectionInfo);
        }
        Object result = this.proceedExecution(method, this.connection, args, this.proxyConfig.getListeners(), this.connectionInfo, onComplete);
        if ("createBatch".equals(methodName)) {
            return this.proxyConfig.getProxyFactory().wrapBatch((Batch)result, this.connectionInfo);
        }
        return result;
    }
}

