/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.QueriesExecutionContext;
import io.r2dbc.proxy.callback.ResultInvocationSubscriber;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

public final class ResultCallbackHandler
extends CallbackHandlerSupport {
    private final Result result;
    private final MutableQueryExecutionInfo queryExecutionInfo;
    private final QueriesExecutionContext queriesExecutionContext;

    public ResultCallbackHandler(Result result, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig, QueriesExecutionContext queriesExecutionContext) {
        super(proxyConfig);
        this.result = Assert.requireNonNull(result, "result must not be null");
        Assert.requireNonNull(queryExecutionInfo, "queryExecutionInfo must not be null");
        this.queryExecutionInfo = Assert.requireType(queryExecutionInfo, MutableQueryExecutionInfo.class, "queryExecutionInfo must be MutableQueryExecutionInfo");
        Assert.requireNonNull(queriesExecutionContext, "queriesExecutionContext must not be null");
        this.queriesExecutionContext = queriesExecutionContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if (this.isCommonMethod(methodName)) {
            return this.handleCommonMethod(methodName, this.result, args, connectionInfo.getOriginalConnection());
        }
        boolean isMapRowMethod = "map".equals(methodName);
        if (isMapRowMethod) {
            args[0] = args[0] instanceof BiFunction ? this.createMappingForMap((BiFunction)args[0]) : this.createMappingForMap((Function)args[0]);
        } else if ("flatMap".equals(methodName)) {
            args[0] = this.createMappingForFlatMap((Function)args[0]);
        }
        Object invocationResult = this.proceedExecution(method, this.result, args, this.proxyConfig.getListeners(), connectionInfo, null);
        if (isMapRowMethod || "flatMap".equals(methodName) || "getRowsUpdated".equals(methodName)) {
            Function transformer = Operators.liftPublisher((pub, subscriber) -> new ResultInvocationSubscriber((CoreSubscriber<Object>)subscriber, this.queryExecutionInfo, this.proxyConfig, this.queriesExecutionContext));
            return Flux.from((Publisher)((Publisher)invocationResult)).transform(transformer);
        }
        return invocationResult;
    }

    private Function<? super Readable, ?> createMappingForMap(Function<? super Readable, ?> mapping) {
        return readable -> {
            if (readable instanceof Row) {
                Row rowProxy = this.proxyConfig.getProxyFactory().wrapRow((Row)readable, this.queryExecutionInfo);
                return mapping.apply((Readable)rowProxy);
            }
            return mapping.apply((Readable)readable);
        };
    }

    private BiFunction<Row, RowMetadata, ?> createMappingForMap(BiFunction<Row, RowMetadata, ?> mapping) {
        return (row, rowMetadata) -> {
            Row rowProxy = this.proxyConfig.getProxyFactory().wrapRow((Row)row, this.queryExecutionInfo);
            return mapping.apply(rowProxy, (RowMetadata)rowMetadata);
        };
    }

    private Function<Result.Segment, Publisher<?>> createMappingForFlatMap(Function<Result.Segment, Publisher<?>> mapping) {
        return segment -> {
            if (segment instanceof Result.RowSegment) {
                Result.RowSegment rowSegmentProxy = this.proxyConfig.getProxyFactory().wrapRowSegment((Result.RowSegment)segment, this.queryExecutionInfo);
                return (Publisher)mapping.apply((Result.Segment)rowSegmentProxy);
            }
            return (Publisher)mapping.apply((Result.Segment)segment);
        };
    }
}

