/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import java.time.Duration;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.DefaultHttpClient;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;

public interface HttpClient
extends AutoCloseable {
    public static HttpClient of(Action<? super HttpClientSpec> action) throws Exception {
        return DefaultHttpClient.of(action);
    }

    public Promise<ReceivedResponse> get(URI var1, Action<? super RequestSpec> var2);

    default public Promise<ReceivedResponse> get(URI uri) {
        return this.get(uri, (Action<? super RequestSpec>)Action.noop());
    }

    public ByteBufAllocator getByteBufAllocator();

    public int getPoolSize();

    public int getPoolQueueSize();

    public Duration getReadTimeout();

    public Duration getConnectTimeout();

    public int getMaxContentLength();

    public int getMaxResponseChunkSize();

    @Override
    public void close();

    public HttpClient copyWith(Action<? super HttpClientSpec> var1) throws Exception;

    public Promise<ReceivedResponse> post(URI var1, Action<? super RequestSpec> var2);

    public Promise<ReceivedResponse> request(URI var1, Action<? super RequestSpec> var2);

    public Promise<StreamedResponse> requestStream(URI var1, Action<? super RequestSpec> var2);

    @Deprecated
    public static HttpClient httpClient(ServerConfig serverConfig, Registry registry) {
        return (HttpClient)Exceptions.uncheck(() -> HttpClient.of((Action<? super HttpClientSpec>)((Action)s -> s.poolSize(0).byteBufAllocator((ByteBufAllocator)registry.get(ByteBufAllocator.class)).maxContentLength(serverConfig.getMaxContentLength()))));
    }

    @Deprecated
    public static HttpClient httpClient(ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        return (HttpClient)Exceptions.uncheck(() -> HttpClient.of((Action<? super HttpClientSpec>)((Action)s -> s.poolSize(0).byteBufAllocator(byteBufAllocator).maxContentLength(maxContentLengthBytes))));
    }
}

