/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.channel.Channel;
import java.util.concurrent.atomic.LongAdder;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.NoopFixedChannelPoolHandler;

public class InstrumentedFixedChannelPoolHandler
extends NoopFixedChannelPoolHandler {
    private final LongAdder activeConnectionCount = new LongAdder();
    private final int maxConnectionCount;

    public InstrumentedFixedChannelPoolHandler(HttpChannelKey channelKey, int poolSize) {
        super(channelKey);
        this.maxConnectionCount = poolSize;
    }

    @Override
    public void channelCreated(Channel ch) throws Exception {
        super.channelCreated(ch);
        this.activeConnectionCount.increment();
    }

    @Override
    public void channelReleased(Channel ch) throws Exception {
        super.channelReleased(ch);
        this.activeConnectionCount.decrement();
    }

    @Override
    public void channelAcquired(Channel ch) throws Exception {
        super.channelAcquired(ch);
        this.activeConnectionCount.increment();
    }

    @Override
    public int getActiveConnectionCount() {
        return this.activeConnectionCount.intValue();
    }

    @Override
    public int getIdleConnectionCount() {
        return this.maxConnectionCount - this.getActiveConnectionCount();
    }
}

