/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.Optional;
import ratpack.api.Nullable;
import ratpack.exec.ExecController;
import ratpack.exec.ExecutionException;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.func.Factory;

public class ExecThreadBinding {
    private final Thread thread;
    private final boolean compute;
    private final ExecController execController;
    private DefaultExecution execution;
    private static final FastThreadLocal<ExecThreadBinding> STORAGE = new FastThreadLocal();

    public ExecThreadBinding(Thread thread, boolean compute, ExecController execController) {
        this.thread = thread;
        this.compute = compute;
        this.execController = execController;
    }

    public static void bind(boolean compute, ExecController execController) {
        STORAGE.set((Object)new ExecThreadBinding(Thread.currentThread(), compute, execController));
    }

    public static void unbind() {
        STORAGE.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T bindFor(boolean compute, ExecController execController, Factory<T> function) throws Exception {
        ExecThreadBinding current = (ExecThreadBinding)STORAGE.get();
        if (current != null && current.getExecController() == execController) {
            return (T)function.create();
        }
        ExecThreadBinding.bind(compute, execController);
        try {
            Object object = function.create();
            return (T)object;
        }
        finally {
            ExecThreadBinding.unbind();
            if (current != null) {
                STORAGE.set((Object)current);
            }
        }
    }

    public boolean isCurrentThread() {
        return this.thread == Thread.currentThread();
    }

    @Nullable
    public static ExecThreadBinding get() {
        return (ExecThreadBinding)STORAGE.get();
    }

    public static Optional<ExecThreadBinding> maybeGet() {
        return Optional.ofNullable((ExecThreadBinding)STORAGE.get());
    }

    public static ExecThreadBinding require() {
        ExecThreadBinding execThreadBinding = (ExecThreadBinding)STORAGE.get();
        if (execThreadBinding == null) {
            throw new UnmanagedThreadException();
        }
        return execThreadBinding;
    }

    public DefaultExecution getExecution() {
        return this.execution;
    }

    public void setExecution(DefaultExecution execution) {
        this.execution = execution;
    }

    public boolean isCompute() {
        return this.compute;
    }

    public ExecController getExecController() {
        return this.execController;
    }

    public static void requireComputeThread(String message) {
        if (!ExecThreadBinding.require().isCompute()) {
            throw new ExecutionException(ExecThreadBinding.toMessage(message));
        }
    }

    public static void requireBlockingThread(String message) {
        if (ExecThreadBinding.require().isCompute()) {
            throw new ExecutionException(ExecThreadBinding.toMessage(message));
        }
    }

    private static String toMessage(String message) {
        return message + " - current thread name = '" + Thread.currentThread().getName() + "'.";
    }
}

