/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.bytebuf.internal.ByteBufComposingPublisher;
import ratpack.util.Exceptions;

public class ByteBufStreams {
    private ByteBufStreams() {
    }

    public static TransformablePublisher<CompositeByteBuf> buffer(Publisher<? extends ByteBuf> publisher, long sizeWatermark, int maxNum) {
        return ByteBufStreams.buffer(publisher, sizeWatermark, maxNum, ByteBufAllocator.DEFAULT);
    }

    public static TransformablePublisher<CompositeByteBuf> buffer(Publisher<? extends ByteBuf> publisher, long sizeWatermark, int maxNum, ByteBufAllocator alloc) {
        return new ByteBufComposingPublisher(maxNum, sizeWatermark, alloc, publisher);
    }

    public static Promise<CompositeByteBuf> compose(Publisher<? extends ByteBuf> publisher) {
        return ByteBufStreams.compose(publisher, ByteBufAllocator.DEFAULT);
    }

    public static Promise<CompositeByteBuf> compose(Publisher<? extends ByteBuf> publisher, ByteBufAllocator alloc) {
        return Promise.flatten(() -> {
            CompositeByteBuf seed = alloc.compositeBuffer();
            return Streams.reduce(publisher, seed, (c, b) -> c.addComponent(true, b)).onError(e -> {
                seed.release();
                throw Exceptions.toException(e);
            });
        });
    }

    public static Promise<byte[]> toByteArray(Publisher<? extends ByteBuf> publisher) {
        return ByteBufStreams.compose(publisher).map(byteBuf -> {
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            byteBuf.release();
            return bytes;
        });
    }

    public static Publisher<byte[]> toByteArrays(Publisher<? extends ByteBuf> publisher) {
        return Streams.map(publisher, b -> {
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)b);
            b.release();
            return bytes;
        });
    }
}

