/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.func.Action;

public abstract class ManagedSubscription<T>
implements Subscription {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedSubscription.class);
    private volatile boolean open;
    private final AtomicLong demand = new AtomicLong();
    private final Action<? super T> disposer;
    private final Subscriber<? super T> subscriber;
    private final AtomicBoolean done = new AtomicBoolean();

    public ManagedSubscription(Subscriber<? super T> subscriber, Action<? super T> disposer) {
        this.subscriber = subscriber;
        this.disposer = disposer;
    }

    public final void request(long n) {
        if (n < 1L) {
            this.subscriber.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
            this.cancel();
            return;
        }
        if (!this.open) {
            if (n == Long.MAX_VALUE) {
                this.open = true;
                this.demand.set(Long.MAX_VALUE);
            } else {
                long newDemand = this.demand.addAndGet(n);
                if (newDemand < 1L || newDemand == Long.MAX_VALUE) {
                    this.open = true;
                    n = Long.MAX_VALUE;
                    this.demand.set(Long.MAX_VALUE);
                }
            }
            this.onRequest(n);
        }
    }

    protected long getDemand() {
        return this.isDone() ? 0L : this.demand.get();
    }

    protected boolean shouldEmit() {
        return this.isDone() || this.demand.get() > 0L;
    }

    protected boolean isDone() {
        return this.done.get();
    }

    protected boolean hasDemand() {
        return this.getDemand() > 0L;
    }

    protected abstract void onRequest(long var1);

    protected abstract void onCancel();

    protected void emitNext(T item) {
        if (this.isDone()) {
            this.dispose(item);
        } else {
            if (!this.open) {
                this.demand.decrementAndGet();
            }
            this.subscriber.onNext(item);
        }
    }

    protected void emitError(Throwable error) {
        if (this.fireDone()) {
            this.subscriber.onError(error);
        }
    }

    protected void emitComplete() {
        if (this.fireDone()) {
            this.subscriber.onComplete();
        }
    }

    protected void dispose(T item) {
        block2: {
            try {
                this.disposer.execute(item);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("exception raised disposing of " + item + " - will be ignored", (Throwable)e);
            }
        }
    }

    private boolean fireDone() {
        return this.done.compareAndSet(false, true);
    }

    public void cancel() {
        this.onCancel();
        this.fireDone();
    }
}

