/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class IoUtils {
    public static ByteBuf read(ByteBufAllocator allocator, Path path) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuf byteBuf;
            block12: {
                InputStream in = Channels.newInputStream(sbc);
                try {
                    int size = Ints.checkedCast((long)sbc.size());
                    ByteBuf byteBuf2 = allocator.directBuffer(size, size);
                    byteBuf2.writeBytes(in, size);
                    byteBuf = byteBuf2;
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byteBuf;
        }
    }
}

