/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal.capture;

import groovy.lang.Closure;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.codehaus.groovy.runtime.ComposedClosure;
import ratpack.func.Block;
import ratpack.func.Function;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.capture.RatpackDslBacking;
import ratpack.groovy.internal.capture.RatpackDslScriptCapture;
import ratpack.groovy.internal.capture.RatpackScriptBacking;
import ratpack.util.Exceptions;
import ratpack.util.internal.Paths2;

public class RatpackDslClosures {
    private Closure<?> handlers = Closure.IDENTITY;
    private Closure<?> bindings = Closure.IDENTITY;
    private Closure<?> serverConfig = Closure.IDENTITY;
    private Path thisScript;
    private boolean closed;

    public RatpackDslClosures(Path thisScript) {
        this.thisScript = thisScript;
    }

    public Closure<?> getHandlers() {
        return this.handlers;
    }

    public Closure<?> getBindings() {
        return this.bindings;
    }

    public Closure<?> getServerConfig() {
        return this.serverConfig;
    }

    public void setHandlers(Closure<?> handlers) {
        this.assertAtTopLevelOfRatpackDsl("handlers");
        this.handlers = new ComposedClosure(handlers, this.handlers);
    }

    public void setBindings(Closure<?> bindings) {
        this.assertAtTopLevelOfRatpackDsl("bindings");
        this.bindings = new ComposedClosure(bindings, this.bindings);
    }

    public void setServerConfig(Closure<?> serverConfig) {
        this.assertAtTopLevelOfRatpackDsl("serverConfig");
        this.serverConfig = new ComposedClosure(serverConfig, this.serverConfig);
    }

    public void include(Path path) {
        this.assertAtTopLevelOfRatpackDsl("include");
        Exceptions.uncheck(() -> {
            Path resolvedPath = path;
            if (this.thisScript != null && !path.isAbsolute()) {
                resolvedPath = this.thisScript.resolveSibling(path);
            }
            String script = Paths2.readText((Path)resolvedPath, (Charset)StandardCharsets.UTF_8);
            RatpackDslClosures closures = new RatpackDslScriptCapture(false, new String[0], (Function<? super RatpackDslClosures, ? extends Groovy.Ratpack>)((Function)RatpackDslBacking::new)).apply(resolvedPath, script);
            this.setServerConfig(closures.getServerConfig());
            this.setBindings(closures.getBindings());
            this.setHandlers(closures.getHandlers());
        });
    }

    private void assertAtTopLevelOfRatpackDsl(String methodName) {
        if (this.closed) {
            throw new IllegalStateException(methodName + " {} DSL method can only be used at the top level of the ratpack {} block");
        }
    }

    public static RatpackDslClosures capture(Function<? super RatpackDslClosures, ? extends Groovy.Ratpack> function, Path script, Block action) throws Exception {
        RatpackDslClosures closures = new RatpackDslClosures(script);
        Groovy.Ratpack receiver = (Groovy.Ratpack)function.apply((Object)closures);
        RatpackScriptBacking.withBacking(closure -> ClosureUtil.configureDelegateFirst(receiver, closure), action);
        closures.closed = true;
        return closures;
    }
}

