/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import ratpack.exec.Promise;
import ratpack.func.Function;
import ratpack.groovy.template.internal.CompiledTextTemplate;
import ratpack.groovy.template.internal.TextTemplateSource;

public class Render {
    private final ByteBufAllocator bufferAllocator;
    private final Function<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache;
    private final TextTemplateSource templateSource;
    private final Map<String, ?> model;
    private final Function<String, TextTemplateSource> includeTransformer;

    private Render(ByteBufAllocator bufferAllocator, Function<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource, Map<String, ?> model, Function<String, TextTemplateSource> includeTransformer) {
        this.bufferAllocator = bufferAllocator;
        this.compiledTemplateCache = compiledTemplateCache;
        this.templateSource = templateSource;
        this.model = model;
        this.includeTransformer = includeTransformer;
    }

    private Promise<ByteBuf> invoke() {
        return Promise.async(f -> {
            ByteBuf byteBuf = this.bufferAllocator.ioBuffer();
            try {
                CompiledTextTemplate fromCache = this.getFromCache(this.compiledTemplateCache, this.templateSource);
                this.execute(fromCache, this.model, byteBuf);
                f.success((Object)byteBuf);
            }
            catch (Throwable e) {
                byteBuf.release();
                f.error(e);
            }
        });
    }

    private CompiledTextTemplate getFromCache(Function<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource) throws Exception {
        return (CompiledTextTemplate)compiledTemplateCache.apply((Object)templateSource);
    }

    private void executeNested(String templatePath, Map<String, ?> model, ByteBuf buffer) throws Exception {
        TextTemplateSource templateSource = (TextTemplateSource)this.includeTransformer.apply((Object)templatePath);
        CompiledTextTemplate compiledTemplate = this.getFromCache(this.compiledTemplateCache, templateSource);
        this.execute(compiledTemplate, model, buffer);
    }

    private void execute(CompiledTextTemplate compiledTemplate, Map<String, ?> model, ByteBuf parts) throws Exception {
        compiledTemplate.execute(model, parts, (String templatePath, Map<String, ?> nestedModel) -> {
            HashMap modelCopy = new HashMap(model);
            modelCopy.putAll(nestedModel);
            this.executeNested(templatePath, modelCopy, parts);
        });
    }

    public static Promise<ByteBuf> render(ByteBufAllocator bufferAllocator, Function<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache, TextTemplateSource templateSource, Map<String, ?> model, Function<String, TextTemplateSource> includeTransformer) throws Exception {
        return new Render(bufferAllocator, compiledTemplateCache, templateSource, model, includeTransformer).invoke();
    }
}

