/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.template.internal.CompiledTextTemplate;
import ratpack.groovy.template.internal.DefaultTextTemplateScript;
import ratpack.groovy.template.internal.Render;
import ratpack.groovy.template.internal.TextTemplateCompiler;
import ratpack.groovy.template.internal.TextTemplateSource;

public class TextTemplateRenderingEngine {
    private final ConcurrentMap<TextTemplateSource, CompiledTextTemplate> compiledTemplateCache;
    private final TextTemplateCompiler templateCompiler;
    private final ByteBufAllocator byteBufAllocator;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;

    @Inject
    public TextTemplateRenderingEngine(ByteBufAllocator byteBufAllocator, FileSystemBinding templateDir, boolean reloadable, boolean staticCompile) {
        this.byteBufAllocator = byteBufAllocator;
        this.reloadable = reloadable;
        this.templateDir = templateDir;
        ScriptEngine<DefaultTextTemplateScript> scriptEngine = new ScriptEngine<DefaultTextTemplateScript>(this.getClass().getClassLoader(), staticCompile, DefaultTextTemplateScript.class);
        this.templateCompiler = new TextTemplateCompiler(scriptEngine, byteBufAllocator);
        this.compiledTemplateCache = new ConcurrentHashMap<TextTemplateSource, CompiledTextTemplate>();
    }

    private CompiledTextTemplate get(TextTemplateSource templateSource) {
        return this.compiledTemplateCache.computeIfAbsent(templateSource, this::compile);
    }

    private CompiledTextTemplate compile(TextTemplateSource templateSource) {
        ByteBuf content;
        try {
            content = templateSource.getContent();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            CompiledTextTemplate e = this.templateCompiler.compile(content, templateSource.getName());
            return e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            content.release();
        }
    }

    public Promise<ByteBuf> renderTemplate(String templateId, Map<String, ?> model) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        return this.render(this.toTemplateSource(templateId, templateFile), model);
    }

    private TextTemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new TextTemplateSource(this.byteBufAllocator, id, templateFile, templateId);
    }

    private Promise<ByteBuf> render(TextTemplateSource templateSource, Map<String, ?> model) throws Exception {
        return Render.render(this.byteBufAllocator, (Function<TextTemplateSource, CompiledTextTemplate>)((Function)this::get), templateSource, model, (Function<String, TextTemplateSource>)((Function)templateName -> this.toTemplateSource((String)templateName, this.getTemplateFile((String)templateName))));
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

