/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.List;
import ratpack.func.Action;
import ratpack.guice.BindingsSpec;
import ratpack.guice.ConfigurableModule;
import ratpack.server.ServerConfig;

public class DefaultBindingsSpec
implements BindingsSpec {
    private final List<Module> modules;
    private final ServerConfig serverConfig;
    private final List<Action<? super Binder>> binderActions;

    public DefaultBindingsSpec(ServerConfig serverConfig, List<Action<? super Binder>> binderActions, List<Module> modules) {
        this.serverConfig = serverConfig;
        this.binderActions = binderActions;
        this.modules = modules;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public BindingsSpec module(Module module) {
        this.modules.add(module);
        return this;
    }

    @Override
    public BindingsSpec module(Class<? extends Module> moduleClass) {
        return this.module(this.createModule(moduleClass));
    }

    private <T extends Module> T createModule(Class<T> clazz) {
        try {
            return (T)((Module)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Module " + clazz.getName() + " is not reflectively instantiable", e);
        }
    }

    @Override
    public <C> BindingsSpec module(ConfigurableModule<C> module, Action<? super C> configurer) {
        module.configure(configurer);
        return this.module((Module)module);
    }

    @Override
    public <C, T extends ConfigurableModule<C>> BindingsSpec module(Class<T> moduleClass, Action<? super C> configurer) {
        ConfigurableModule t = (ConfigurableModule)((Object)this.createModule(moduleClass));
        return this.module(t, configurer);
    }

    @Override
    public <C> BindingsSpec moduleConfig(ConfigurableModule<C> module, C config, Action<? super C> configurer) {
        module.setConfig(config);
        return this.module(module, configurer);
    }

    @Override
    public <C, T extends ConfigurableModule<C>> BindingsSpec moduleConfig(Class<T> moduleClass, C config, Action<? super C> configurer) {
        ConfigurableModule t = (ConfigurableModule)((Object)this.createModule(moduleClass));
        return this.moduleConfig(t, config, configurer);
    }

    @Override
    public BindingsSpec binder(Action<? super Binder> action) {
        this.binderActions.add(action);
        return this;
    }
}

