/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hystrix;

import com.google.inject.Singleton;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import ratpack.guice.ConfigurableModule;
import ratpack.hystrix.internal.HystrixCollapserMetricsBroadcaster;
import ratpack.hystrix.internal.HystrixCollapserMetricsJsonMapper;
import ratpack.hystrix.internal.HystrixCollapserMetricsPeriodicPublisher;
import ratpack.hystrix.internal.HystrixCommandMetricsBroadcaster;
import ratpack.hystrix.internal.HystrixCommandMetricsJsonMapper;
import ratpack.hystrix.internal.HystrixCommandMetricsPeriodicPublisher;
import ratpack.hystrix.internal.HystrixRegistryBackedConcurrencyStrategy;
import ratpack.hystrix.internal.HystrixThreadPoolMetricsBroadcaster;
import ratpack.hystrix.internal.HystrixThreadPoolMetricsJsonMapper;
import ratpack.hystrix.internal.HystrixThreadPoolMetricsPeriodicPublisher;

public class HystrixModule
extends ConfigurableModule<Config> {
    private boolean reportMetricsToSse;

    protected void configure() {
        block3: {
            try {
                HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)new HystrixRegistryBackedConcurrencyStrategy());
            }
            catch (IllegalStateException e) {
                HystrixConcurrencyStrategy existingStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
                if (existingStrategy instanceof HystrixRegistryBackedConcurrencyStrategy) break block3;
                throw new IllegalStateException("Cannot install Hystrix integration because another concurrency strategy (" + existingStrategy.getClass() + ") is already installed");
            }
        }
        if (this.reportMetricsToSse) {
            this.bind(HystrixCommandMetricsPeriodicPublisher.class).in(Singleton.class);
            this.bind(HystrixCommandMetricsBroadcaster.class).in(Singleton.class);
            this.bind(HystrixCommandMetricsJsonMapper.class).in(Singleton.class);
            this.bind(HystrixThreadPoolMetricsPeriodicPublisher.class).in(Singleton.class);
            this.bind(HystrixThreadPoolMetricsBroadcaster.class).in(Singleton.class);
            this.bind(HystrixThreadPoolMetricsJsonMapper.class).in(Singleton.class);
            this.bind(HystrixCollapserMetricsPeriodicPublisher.class).in(Singleton.class);
            this.bind(HystrixCollapserMetricsBroadcaster.class).in(Singleton.class);
            this.bind(HystrixCollapserMetricsJsonMapper.class).in(Singleton.class);
        }
    }

    public HystrixModule sse() {
        this.reportMetricsToSse = true;
        return this;
    }

    public static class Config {
        public static final long DEFAULT_INTERVAL = 2L;
        private long streamInterval = 2L;

        public long getStreamInterval() {
            return this.streamInterval;
        }

        public Config streamInterval(long streamInterval) {
            this.streamInterval = streamInterval;
            return this;
        }
    }
}

