/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hystrix.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.StringWriter;
import java.io.Writer;
import ratpack.func.Function;

public class HystrixCommandMetricsJsonMapper
implements Function<HystrixCommandMetrics, String> {
    private final JsonFactory jsonFactory = new JsonFactory();

    public String apply(HystrixCommandMetrics commandMetrics) throws Exception {
        HystrixCommandKey key = commandMetrics.getCommandKey();
        HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key);
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = this.jsonFactory.createGenerator((Writer)jsonString);
        json.writeStartObject();
        json.writeStringField("type", "HystrixCommand");
        json.writeStringField("name", key.name());
        json.writeStringField("group", commandMetrics.getCommandGroup().name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        if (circuitBreaker == null) {
            json.writeBooleanField("isCircuitBreakerOpen", false);
        } else {
            json.writeBooleanField("isCircuitBreakerOpen", circuitBreaker.isOpen());
        }
        HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
        json.writeNumberField("errorPercentage", healthCounts.getErrorPercentage());
        json.writeNumberField("errorCount", healthCounts.getErrorCount());
        json.writeNumberField("requestCount", healthCounts.getTotalRequests());
        json.writeNumberField("rollingCountBadRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.BAD_REQUEST));
        json.writeNumberField("rollingCountCollapsedRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSED));
        json.writeNumberField("rollingCountEmit", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EMIT));
        json.writeNumberField("rollingCountExceptionsThrown", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        json.writeNumberField("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        json.writeNumberField("rollingCountEmit", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_EMIT));
        json.writeNumberField("rollingCountFallbackFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
        json.writeNumberField("rollingCountFallbackRejection", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
        json.writeNumberField("rollingCountFallbackSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
        json.writeNumberField("rollingCountResponsesFromCache", commandMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
        json.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
        json.writeNumberField("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
        json.writeNumberField("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
        json.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
        json.writeNumberField("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
        json.writeNumberField("currentConcurrentExecutionCount", commandMetrics.getCurrentConcurrentExecutionCount());
        json.writeNumberField("rollingMaxConcurrentExecutionCount", commandMetrics.getRollingMaxConcurrentExecutions());
        json.writeNumberField("latencyExecute_mean", commandMetrics.getExecutionTimeMean());
        json.writeObjectFieldStart("latencyExecute");
        json.writeNumberField("0", commandMetrics.getExecutionTimePercentile(0.0));
        json.writeNumberField("25", commandMetrics.getExecutionTimePercentile(25.0));
        json.writeNumberField("50", commandMetrics.getExecutionTimePercentile(50.0));
        json.writeNumberField("75", commandMetrics.getExecutionTimePercentile(75.0));
        json.writeNumberField("90", commandMetrics.getExecutionTimePercentile(90.0));
        json.writeNumberField("95", commandMetrics.getExecutionTimePercentile(95.0));
        json.writeNumberField("99", commandMetrics.getExecutionTimePercentile(99.0));
        json.writeNumberField("99.5", commandMetrics.getExecutionTimePercentile(99.5));
        json.writeNumberField("100", commandMetrics.getExecutionTimePercentile(100.0));
        json.writeEndObject();
        json.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
        json.writeObjectFieldStart("latencyTotal");
        json.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
        json.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
        json.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
        json.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
        json.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
        json.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
        json.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
        json.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
        json.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
        json.writeEndObject();
        HystrixCommandProperties commandProperties = commandMetrics.getProperties();
        json.writeNumberField("propertyValue_circuitBreakerRequestVolumeThreshold", ((Integer)commandProperties.circuitBreakerRequestVolumeThreshold().get()).intValue());
        json.writeNumberField("propertyValue_circuitBreakerSleepWindowInMilliseconds", ((Integer)commandProperties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
        json.writeNumberField("propertyValue_circuitBreakerErrorThresholdPercentage", ((Integer)commandProperties.circuitBreakerErrorThresholdPercentage().get()).intValue());
        json.writeBooleanField("propertyValue_circuitBreakerForceOpen", ((Boolean)commandProperties.circuitBreakerForceOpen().get()).booleanValue());
        json.writeBooleanField("propertyValue_circuitBreakerForceClosed", ((Boolean)commandProperties.circuitBreakerForceClosed().get()).booleanValue());
        json.writeBooleanField("propertyValue_circuitBreakerEnabled", ((Boolean)commandProperties.circuitBreakerEnabled().get()).booleanValue());
        json.writeStringField("propertyValue_executionIsolationStrategy", ((HystrixCommandProperties.ExecutionIsolationStrategy)commandProperties.executionIsolationStrategy().get()).name());
        json.writeNumberField("propertyValue_executionIsolationThreadTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
        json.writeNumberField("propertyValue_executionTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
        json.writeBooleanField("propertyValue_executionIsolationThreadInterruptOnTimeout", ((Boolean)commandProperties.executionIsolationThreadInterruptOnTimeout().get()).booleanValue());
        json.writeStringField("propertyValue_executionIsolationThreadPoolKeyOverride", (String)commandProperties.executionIsolationThreadPoolKeyOverride().get());
        json.writeNumberField("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
        json.writeNumberField("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
        json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)commandProperties.metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
        json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)commandProperties.requestCacheEnabled().get()).booleanValue());
        json.writeBooleanField("propertyValue_requestLogEnabled", ((Boolean)commandProperties.requestLogEnabled().get()).booleanValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeEndObject();
        json.close();
        return jsonString.getBuffer().toString();
    }
}

