/*
 * Decompiled with CFR 0.152.
 */
package ratpack.hystrix.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.StringWriter;
import java.io.Writer;
import ratpack.func.Function;

public class HystrixThreadPoolMetricsJsonMapper
implements Function<HystrixThreadPoolMetrics, String> {
    private final JsonFactory jsonFactory = new JsonFactory();

    public String apply(HystrixThreadPoolMetrics threadPoolMetrics) throws Exception {
        HystrixThreadPoolKey key = threadPoolMetrics.getThreadPoolKey();
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = this.jsonFactory.createGenerator((Writer)jsonString);
        json.writeStartObject();
        json.writeStringField("type", "HystrixThreadPool");
        json.writeStringField("name", key.name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        json.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
        json.writeNumberField("currentCompletedTaskCount", threadPoolMetrics.getCurrentCompletedTaskCount().longValue());
        json.writeNumberField("currentCorePoolSize", threadPoolMetrics.getCurrentCorePoolSize().intValue());
        json.writeNumberField("currentLargestPoolSize", threadPoolMetrics.getCurrentLargestPoolSize().intValue());
        json.writeNumberField("currentMaximumPoolSize", threadPoolMetrics.getCurrentMaximumPoolSize().intValue());
        json.writeNumberField("currentPoolSize", threadPoolMetrics.getCurrentPoolSize().intValue());
        json.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
        json.writeNumberField("currentTaskCount", threadPoolMetrics.getCurrentTaskCount().longValue());
        json.writeNumberField("rollingCountThreadsExecuted", threadPoolMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_EXECUTION));
        json.writeNumberField("rollingMaxActiveThreads", threadPoolMetrics.getRollingMaxActiveThreads());
        json.writeNumberField("rollingCountCommandRejections", threadPoolMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
        json.writeNumberField("propertyValue_queueSizeRejectionThreshold", ((Integer)threadPoolMetrics.getProperties().queueSizeRejectionThreshold().get()).intValue());
        json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)threadPoolMetrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeEndObject();
        json.close();
        return jsonString.getBuffer().toString();
    }
}

