/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;

public final class PublisherAsCompletable
implements Completable.OnSubscribe {
    final Publisher<?> publisher;

    public PublisherAsCompletable(Publisher<?> publisher) {
        this.publisher = publisher;
    }

    public void call(CompletableSubscriber t) {
        this.publisher.subscribe((Subscriber)new PublisherAsCompletableSubscriber(t));
    }

    static final class PublisherAsCompletableSubscriber
    implements Subscriber<Object>,
    Subscription {
        final CompletableSubscriber actual;
        org.reactivestreams.Subscription s;
        volatile boolean unsubscribed;

        public PublisherAsCompletableSubscriber(CompletableSubscriber actual) {
            this.actual = actual;
        }

        public void onSubscribe(org.reactivestreams.Subscription s) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Object t) {
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onCompleted();
        }

        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        public void unsubscribe() {
            if (!this.unsubscribed) {
                this.unsubscribed = true;
                this.s.cancel();
            }
        }
    }
}

